/*
 * Decompiled with CFR 0.152.
 */
package cn.javainterview.core.net;

import cn.javainterview.core.exceptions.UtilException;
import cn.javainterview.core.net.RFC3986;
import cn.javainterview.core.util.CharsetUtil;
import cn.javainterview.core.util.StrUtil;
import java.nio.charset.Charset;

public class URLEncodeUtil {
    public static String encodeAll(String url) {
        return URLEncodeUtil.encodeAll(url, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encodeAll(String url, Charset charset) throws UtilException {
        return RFC3986.UNRESERVED.encode(url, charset, new char[0]);
    }

    public static String encode(String url) throws UtilException {
        return URLEncodeUtil.encode(url, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encode(String url, Charset charset) {
        return RFC3986.PATH.encode(url, charset, new char[0]);
    }

    public static String encodeQuery(String url) throws UtilException {
        return URLEncodeUtil.encodeQuery(url, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encodeQuery(String url, Charset charset) {
        return RFC3986.QUERY.encode(url, charset, new char[0]);
    }

    public static String encodePathSegment(String url) throws UtilException {
        return URLEncodeUtil.encodePathSegment(url, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encodePathSegment(String url, Charset charset) {
        if (StrUtil.isEmpty(url)) {
            return url;
        }
        return RFC3986.SEGMENT.encode(url, charset, new char[0]);
    }

    public static String encodeFragment(String url) throws UtilException {
        return URLEncodeUtil.encodeFragment(url, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encodeFragment(String url, Charset charset) {
        if (StrUtil.isEmpty(url)) {
            return url;
        }
        return RFC3986.FRAGMENT.encode(url, charset, new char[0]);
    }
}

