/*
 * Decompiled with CFR 0.152.
 */
package cn.javainterview.core.lang.hash;

import cn.javainterview.core.exceptions.UtilException;
import cn.javainterview.core.lang.hash.Hash32;
import cn.javainterview.core.lang.hash.Hash64;
import cn.javainterview.core.util.StrUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class KetamaHash
implements Hash64<String>,
Hash32<String> {
    @Override
    public long hash64(String key) {
        byte[] bKey = KetamaHash.md5(key);
        return (long)(bKey[3] & 0xFF) << 24 | (long)(bKey[2] & 0xFF) << 16 | (long)(bKey[1] & 0xFF) << 8 | (long)(bKey[0] & 0xFF);
    }

    @Override
    public int hash32(String key) {
        return (int)(this.hash64(key) & 0xFFFFFFFFL);
    }

    @Override
    public Number hash(String key) {
        return this.hash64(key);
    }

    private static byte[] md5(String key) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UtilException("MD5 algorithm not suooport!", e);
        }
        return md5.digest(StrUtil.utf8Bytes(key));
    }
}

