/*
 * Decompiled with CFR 0.152.
 */
package cn.javainterview.core.io.resource;

import cn.javainterview.core.io.IORuntimeException;
import cn.javainterview.core.io.IoUtil;
import cn.javainterview.core.util.CharsetUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;

public interface Resource {
    public String getName();

    public URL getUrl();

    public InputStream getStream();

    default public boolean isModified() {
        return false;
    }

    default public void writeTo(OutputStream out) throws IORuntimeException {
        try (InputStream in = this.getStream();){
            IoUtil.copy(in, out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    default public BufferedReader getReader(Charset charset) {
        return IoUtil.getReader(this.getStream(), charset);
    }

    default public String readStr(Charset charset) throws IORuntimeException {
        return IoUtil.read(this.getReader(charset));
    }

    default public String readUtf8Str() throws IORuntimeException {
        return this.readStr(CharsetUtil.CHARSET_UTF_8);
    }

    default public byte[] readBytes() throws IORuntimeException {
        return IoUtil.readBytes(this.getStream());
    }
}

