/*
 * Decompiled with CFR 0.152.
 */
package cn.javainterview.core.io.resource;

import cn.javainterview.core.collection.CollUtil;
import cn.javainterview.core.io.IORuntimeException;
import cn.javainterview.core.io.resource.Resource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;

public class MultiResource
implements Resource,
Iterable<Resource>,
Iterator<Resource>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Resource> resources;
    private int cursor;

    public MultiResource(Resource ... resources) {
        this(CollUtil.newArrayList(resources));
    }

    public MultiResource(Collection<Resource> resources) {
        this.resources = resources instanceof List ? (List<Object>)resources : CollUtil.newArrayList(resources);
    }

    @Override
    public String getName() {
        return this.resources.get(this.cursor).getName();
    }

    @Override
    public URL getUrl() {
        return this.resources.get(this.cursor).getUrl();
    }

    @Override
    public InputStream getStream() {
        return this.resources.get(this.cursor).getStream();
    }

    @Override
    public boolean isModified() {
        return this.resources.get(this.cursor).isModified();
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        return this.resources.get(this.cursor).getReader(charset);
    }

    @Override
    public String readStr(Charset charset) throws IORuntimeException {
        return this.resources.get(this.cursor).readStr(charset);
    }

    @Override
    public String readUtf8Str() throws IORuntimeException {
        return this.resources.get(this.cursor).readUtf8Str();
    }

    @Override
    public byte[] readBytes() throws IORuntimeException {
        return this.resources.get(this.cursor).readBytes();
    }

    @Override
    public Iterator<Resource> iterator() {
        return this.resources.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.resources.size();
    }

    @Override
    public synchronized Resource next() {
        if (this.cursor >= this.resources.size()) {
            throw new ConcurrentModificationException();
        }
        ++this.cursor;
        return this;
    }

    @Override
    public void remove() {
        this.resources.remove(this.cursor);
    }

    public synchronized void reset() {
        this.cursor = 0;
    }

    public MultiResource add(Resource resource) {
        this.resources.add(resource);
        return this;
    }
}

