/*
 * Decompiled with CFR 0.152.
 */
package cn.javainterview.core.img;

import cn.javainterview.core.lang.Assert;
import java.awt.Color;
import java.awt.color.ColorSpace;

public class LabColor {
    private static final ColorSpace XYZ_COLOR_SPACE = ColorSpace.getInstance(1001);
    private final double l;
    private final double a;
    private final double b;

    public LabColor(Integer rgb) {
        this(rgb != null ? new Color(rgb) : null);
    }

    public LabColor(Color color) {
        Assert.notNull(color, "Color must not be null", new Object[0]);
        float[] lab = this.fromXyz(color.getColorComponents(XYZ_COLOR_SPACE, null));
        this.l = lab[0];
        this.a = lab[1];
        this.b = lab[2];
    }

    public double getDistance(LabColor other) {
        double c1 = Math.sqrt(this.a * this.a + this.b * this.b);
        double deltaC = c1 - Math.sqrt(other.a * other.a + other.b * other.b);
        double deltaA = this.a - other.a;
        double deltaB = this.b - other.b;
        double deltaH = Math.sqrt(Math.max(0.0, deltaA * deltaA + deltaB * deltaB - deltaC * deltaC));
        return Math.sqrt(Math.max(0.0, Math.pow(this.l - other.l, 2.0) + Math.pow(deltaC / (1.0 + 0.045 * c1), 2.0) + Math.pow(deltaH / (1.0 + 0.015 * c1), 2.0)));
    }

    private float[] fromXyz(float[] xyz) {
        return LabColor.fromXyz(xyz[0], xyz[1], xyz[2]);
    }

    private static float[] fromXyz(float x, float y, float z) {
        double l = (LabColor.f(y) - 16.0) * 116.0;
        double a = (LabColor.f(x) - LabColor.f(y)) * 500.0;
        double b = (LabColor.f(y) - LabColor.f(z)) * 200.0;
        return new float[]{(float)l, (float)a, (float)b};
    }

    private static double f(double t) {
        return t > 0.008856451679035631 ? Math.cbrt(t) : 0.3333333333333333 * Math.pow(4.833333333333333, 2.0) * t + 0.13793103448275862;
    }
}

