/*
 * Decompiled with CFR 0.152.
 */
package cn.javainterview.core.date;

import cn.javainterview.core.date.DateUtil;
import cn.javainterview.core.date.Month;
import cn.javainterview.core.lang.Assert;
import java.util.Calendar;
import java.util.Date;

public class Zodiac {
    private static final int[] DAY_ARR = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};
    private static final String[] ZODIACS = new String[]{"\u6469\u7faf\u5ea7", "\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7"};
    private static final String[] CHINESE_ZODIACS = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};

    public static String getZodiac(Date date) {
        return Zodiac.getZodiac(DateUtil.calendar(date));
    }

    public static String getZodiac(Calendar calendar) {
        if (null == calendar) {
            return null;
        }
        return Zodiac.getZodiac(calendar.get(2), calendar.get(5));
    }

    public static String getZodiac(Month month, int day) {
        return Zodiac.getZodiac(month.getValue(), day);
    }

    public static String getZodiac(int month, int day) {
        Assert.checkBetween(month, Month.JANUARY.getValue(), Month.DECEMBER.getValue(), "Unsupported month value, must be [0,12]", new Object[0]);
        return day < DAY_ARR[month] ? ZODIACS[month] : ZODIACS[month + 1];
    }

    public static String getChineseZodiac(Date date) {
        return Zodiac.getChineseZodiac(DateUtil.calendar(date));
    }

    public static String getChineseZodiac(Calendar calendar) {
        if (null == calendar) {
            return null;
        }
        return Zodiac.getChineseZodiac(calendar.get(1));
    }

    public static String getChineseZodiac(int year) {
        if (year < 1900) {
            return null;
        }
        return CHINESE_ZODIACS[(year - 1900) % CHINESE_ZODIACS.length];
    }
}

