/*
 * Decompiled with CFR 0.152.
 */
package cn.javainterview.core.convert.impl;

import cn.javainterview.core.bean.BeanUtil;
import cn.javainterview.core.bean.copier.BeanCopier;
import cn.javainterview.core.bean.copier.CopyOptions;
import cn.javainterview.core.bean.copier.ValueProvider;
import cn.javainterview.core.convert.AbstractConverter;
import cn.javainterview.core.convert.ConvertException;
import cn.javainterview.core.map.MapProxy;
import cn.javainterview.core.util.ObjectUtil;
import cn.javainterview.core.util.ReflectUtil;
import cn.javainterview.core.util.StrUtil;
import cn.javainterview.core.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.Map;

public class BeanConverter<T>
extends AbstractConverter<T> {
    private static final long serialVersionUID = 1L;
    private final Type beanType;
    private final Class<T> beanClass;
    private final CopyOptions copyOptions;

    public BeanConverter(Type beanType) {
        this(beanType, CopyOptions.create().setIgnoreError(true));
    }

    public BeanConverter(Class<T> beanClass) {
        this(beanClass, CopyOptions.create().setIgnoreError(true));
    }

    public BeanConverter(Type beanType, CopyOptions copyOptions) {
        this.beanType = beanType;
        this.beanClass = TypeUtil.getClass(beanType);
        this.copyOptions = copyOptions;
    }

    @Override
    protected T convertInternal(Object value) {
        if (value instanceof Map || value instanceof ValueProvider || BeanUtil.isBean(value.getClass())) {
            if (value instanceof Map && this.beanClass.isInterface()) {
                return MapProxy.create((Map)value).toProxyBean(this.beanClass);
            }
            return BeanCopier.create(value, ReflectUtil.newInstanceIfPossible(this.beanClass), this.beanType, this.copyOptions).copy();
        }
        if (value instanceof byte[]) {
            return ObjectUtil.deserialize((byte[])value, new Class[0]);
        }
        if (StrUtil.isEmptyIfStr(value)) {
            return null;
        }
        throw new ConvertException("Unsupported source type: {}", value.getClass());
    }

    @Override
    public Class<T> getTargetType() {
        return this.beanClass;
    }
}

