/*
 * Decompiled with CFR 0.152.
 */
package cn.javainterview.core.comparator;

import cn.javainterview.core.comparator.ComparatorException;
import cn.javainterview.core.comparator.CompareUtil;
import cn.javainterview.core.comparator.NullComparator;
import cn.javainterview.core.util.ObjectUtil;
import java.util.function.Function;

public class FuncComparator<T>
extends NullComparator<T> {
    private static final long serialVersionUID = 1L;
    private final Function<T, Comparable<?>> func;

    public FuncComparator(boolean nullGreater, Function<T, Comparable<?>> func) {
        super(nullGreater, null);
        this.func = func;
    }

    @Override
    protected int doCompare(T a, T b) {
        Comparable<?> v2;
        Comparable<?> v1;
        try {
            v1 = this.func.apply(a);
            v2 = this.func.apply(b);
        }
        catch (Exception e) {
            throw new ComparatorException(e);
        }
        return this.compare(a, b, v1, v2);
    }

    private int compare(T o1, T o2, Comparable v1, Comparable v2) {
        int result = ObjectUtil.compare(v1, v2, this.nullGreater);
        if (0 == result) {
            result = CompareUtil.compare(o1, o2, this.nullGreater);
        }
        return result;
    }
}

