/*
 * Decompiled with CFR 0.152.
 */
package cn.javainterview.core.comparator;

import cn.javainterview.core.comparator.FuncComparator;
import cn.javainterview.core.lang.Assert;
import cn.javainterview.core.util.ClassUtil;
import cn.javainterview.core.util.ReflectUtil;
import cn.javainterview.core.util.StrUtil;
import java.lang.reflect.Field;

public class FieldComparator<T>
extends FuncComparator<T> {
    private static final long serialVersionUID = 9157326766723846313L;

    public FieldComparator(Class<T> beanClass, String fieldName) {
        this(FieldComparator.getNonNullField(beanClass, fieldName));
    }

    public FieldComparator(Field field) {
        this(true, field);
    }

    public FieldComparator(boolean nullGreater, Field field) {
        super(nullGreater, (T bean) -> (Comparable)ReflectUtil.getFieldValue(bean, Assert.notNull(field, "Field must be not null!", new Object[0])));
    }

    private static Field getNonNullField(Class<?> beanClass, String fieldName) {
        Field field = ClassUtil.getDeclaredField(beanClass, fieldName);
        if (field == null) {
            throw new IllegalArgumentException(StrUtil.format("Field [{}] not found in Class [{}]", fieldName, beanClass.getName()));
        }
        return field;
    }
}

