/*
 * Decompiled with CFR 0.152.
 */
package cn.javainterview.core.bean.copier.provider;

import cn.javainterview.core.bean.BeanUtil;
import cn.javainterview.core.bean.PropDesc;
import cn.javainterview.core.bean.copier.ValueProvider;
import cn.javainterview.core.lang.Editor;
import cn.javainterview.core.map.FuncKeyMap;
import cn.javainterview.core.util.StrUtil;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class BeanValueProvider
implements ValueProvider<String> {
    private final Object source;
    private final boolean ignoreError;
    final Map<String, PropDesc> sourcePdMap;

    public BeanValueProvider(Object bean, boolean ignoreCase, boolean ignoreError) {
        this(bean, ignoreCase, ignoreError, null);
    }

    public BeanValueProvider(Object bean, boolean ignoreCase, boolean ignoreError, Editor<String> keyEditor) {
        this.source = bean;
        this.ignoreError = ignoreError;
        Map<String, PropDesc> sourcePdMap = BeanUtil.getBeanDesc(this.source.getClass()).getPropMap(ignoreCase);
        this.sourcePdMap = new FuncKeyMap<String, PropDesc>(new HashMap(sourcePdMap.size(), 1.0f), (Function<Object, String> & Serializable)key -> {
            if (ignoreCase && key instanceof CharSequence) {
                key = key.toString().toLowerCase();
            }
            if (null != keyEditor) {
                key = keyEditor.edit(key.toString());
            }
            return key.toString();
        });
        this.sourcePdMap.putAll(sourcePdMap);
    }

    @Override
    public Object value(String key, Type valueType) {
        PropDesc sourcePd = this.getPropDesc(key, valueType);
        Object result = null;
        if (null != sourcePd) {
            result = sourcePd.getValue(this.source, valueType, this.ignoreError);
        }
        return result;
    }

    @Override
    public boolean containsKey(String key) {
        PropDesc sourcePd = this.getPropDesc(key, null);
        return null != sourcePd && sourcePd.isReadable(false);
    }

    private PropDesc getPropDesc(String key, Type valueType) {
        PropDesc sourcePd = this.sourcePdMap.get(key);
        if (null == sourcePd && (null == valueType || Boolean.class == valueType || Boolean.TYPE == valueType)) {
            sourcePd = this.sourcePdMap.get(StrUtil.upperFirstAndAddPre(key, "is"));
        }
        return sourcePd;
    }
}

