/*
 * Decompiled with CFR 0.152.
 */
package cn.javainterview.core.annotation.scanner;

import cn.javainterview.core.annotation.scanner.AnnotationScanner;
import cn.javainterview.core.annotation.scanner.ElementAnnotationScanner;
import cn.javainterview.core.annotation.scanner.EmptyAnnotationScanner;
import cn.javainterview.core.annotation.scanner.MetaAnnotationScanner;
import cn.javainterview.core.annotation.scanner.MethodAnnotationScanner;
import cn.javainterview.core.annotation.scanner.TypeAnnotationScanner;
import cn.javainterview.core.map.multi.ListValueMap;
import cn.javainterview.core.util.ObjectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public class GenericAnnotationScanner
implements AnnotationScanner {
    private final AnnotationScanner typeScanner;
    private final AnnotationScanner methodScanner;
    private final AnnotationScanner metaScanner;
    private final AnnotationScanner elementScanner;

    @Override
    public boolean support(AnnotatedElement annotatedEle) {
        return true;
    }

    public GenericAnnotationScanner(boolean enableScanMetaAnnotation, boolean enableScanSupperClass, boolean enableScanSupperInterface) {
        this.metaScanner = enableScanMetaAnnotation ? new MetaAnnotationScanner() : new EmptyAnnotationScanner();
        this.typeScanner = new TypeAnnotationScanner(enableScanSupperClass, enableScanSupperInterface, a -> true, Collections.emptySet());
        this.methodScanner = new MethodAnnotationScanner(enableScanSupperClass, enableScanSupperInterface, a -> true, Collections.emptySet());
        this.elementScanner = new ElementAnnotationScanner();
    }

    @Override
    public void scan(BiConsumer<Integer, Annotation> consumer, AnnotatedElement annotatedEle, Predicate<Annotation> filter) {
        filter = ObjectUtil.defaultIfNull(filter, a -> t -> true);
        if (ObjectUtil.isNull(annotatedEle)) {
            return;
        }
        if (annotatedEle instanceof Class) {
            this.scanElements(this.typeScanner, consumer, annotatedEle, filter);
        } else if (annotatedEle instanceof Method) {
            this.scanElements(this.methodScanner, consumer, annotatedEle, filter);
        } else {
            this.scanElements(this.elementScanner, consumer, annotatedEle, filter);
        }
    }

    private void scanElements(AnnotationScanner scanner, BiConsumer<Integer, Annotation> consumer, AnnotatedElement annotatedEle, Predicate<Annotation> filter) {
        ListValueMap<Integer, List> classAnnotations = new ListValueMap<Integer, List>(new LinkedHashMap());
        scanner.scan((index, annotation) -> {
            if (filter.test((Annotation)annotation)) {
                classAnnotations.putValue((Integer)index, (List)annotation);
            }
        }, annotatedEle, filter);
        classAnnotations.forEach((index, annotations) -> annotations.forEach(annotation -> {
            consumer.accept((Integer)index, (Annotation)annotation);
            this.metaScanner.scan(consumer, annotation.annotationType(), filter);
        }));
    }
}

