/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.jany.spring.autoconfigure.springdoc;

import cn.javaer.jany.model.PageParam;
import cn.javaer.jany.spring.autoconfigure.springdoc.ExceptionResponseBuilder;
import cn.javaer.jany.spring.autoconfigure.springdoc.PageableDoc;
import cn.javaer.jany.spring.autoconfigure.springdoc.SpringPageConverter;
import cn.javaer.jany.spring.autoconfigure.springdoc.SpringdocProperties;
import cn.javaer.jany.spring.autoconfigure.web.exception.ExceptionAutoConfiguration;
import cn.javaer.jany.spring.security.PrincipalId;
import cn.javaer.jany.spring.web.exception.ErrorInfoProcessor;
import io.swagger.v3.core.util.PrimitiveType;
import java.util.List;
import org.springdoc.core.GenericResponseService;
import org.springdoc.core.OperationService;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.ReturnTypeParser;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SpringDocConfiguration;
import org.springdoc.core.SpringDocUtils;
import org.springdoc.core.converters.PageableOpenAPIConverter;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SpringDocConfiguration.class})
@AutoConfigureAfter(value={ExceptionAutoConfiguration.class})
@AutoConfigureBefore(value={SpringDocConfiguration.class, SpringDocConfigProperties.class})
@ConditionalOnProperty(prefix="jany.springdoc", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={SpringdocProperties.class})
public class SpringdocAutoConfiguration
implements InitializingBean {
    @Bean
    @ConditionalOnMissingBean
    GenericResponseService responseBuilder(OperationService operationBuilder, ErrorInfoProcessor errorInfoProcessor, List<ReturnTypeParser> returnTypeParsers, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils) {
        return new ExceptionResponseBuilder(operationBuilder, returnTypeParsers, springDocConfigProperties, propertyResolverUtils, errorInfoProcessor);
    }

    public void afterPropertiesSet() {
        SpringDocUtils.getConfig().replaceParameterObjectWithClass(PageParam.class, PageableDoc.class);
        PrimitiveType.customClasses().put("java.time.LocalTime", PrimitiveType.PARTIAL_TIME);
    }

    @ConditionalOnClass(value={Pageable.class})
    static class SpringDocPageableConfiguration {
        SpringDocPageableConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public SpringPageConverter springPageConverter(ObjectMapperProvider springDocObjectMapper) {
            return new SpringPageConverter(springDocObjectMapper);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(name={"springdoc.model-converters.pageable-converter.enabled"}, matchIfMissing=true)
        @Lazy(value=false)
        PageableOpenAPIConverter pageableOpenAPIConverter(ObjectMapperProvider objectMapperProvider) {
            SpringDocUtils.getConfig().replaceParameterObjectWithClass(Pageable.class, PageableDoc.class);
            SpringDocUtils.getConfig().replaceParameterObjectWithClass(PageRequest.class, PageableDoc.class);
            SpringDocUtils.getConfig().addAnnotationsToIgnore(new Class[]{PrincipalId.class});
            return new PageableOpenAPIConverter(objectMapperProvider);
        }
    }
}

