/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.jany.spring.autoconfigure.springdoc;

import cn.javaer.jany.spring.autoconfigure.springdoc.SpringPage;
import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Iterator;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springframework.core.ResolvableType;

public class SpringPageConverter
implements ModelConverter {
    private static final String SPRING_PAGE = "org.springframework.data.domain.Page";
    private final ObjectMapperProvider springDocObjectMapper;

    public SpringPageConverter(ObjectMapperProvider springDocObjectMapper) {
        this.springDocObjectMapper = springDocObjectMapper;
    }

    public Schema<?> resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Class cls;
        JavaType javaType = this.springDocObjectMapper.jsonMapper().constructType(type.getType());
        if (javaType != null && SPRING_PAGE.equals((cls = javaType.getRawClass()).getCanonicalName())) {
            Class generic = javaType.getBindings().getBoundType(0).getRawClass();
            ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SpringPage.class, (Class[])new Class[]{generic});
            type = new AnnotatedType(resolvableType.getType()).resolveAsRef(true);
        }
        return chain.hasNext() ? chain.next().resolve(type, context, chain) : null;
    }
}

