/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.jany.spring.autoconfigure.springdoc;

import cn.hutool.core.util.StrUtil;
import cn.javaer.jany.exception.ErrorInfo;
import cn.javaer.jany.exception.RuntimeErrorInfo;
import cn.javaer.jany.spring.web.exception.ErrorInfoProcessor;
import cn.javaer.jany.spring.web.exception.ErrorMessageSource;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.GenericResponseService;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.OperationService;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.ReturnTypeParser;
import org.springdoc.core.SpringDocConfigProperties;
import org.springframework.web.method.HandlerMethod;

class ExceptionResponseBuilder
extends GenericResponseService {
    private static final Logger log = LoggerFactory.getLogger(ExceptionResponseBuilder.class);
    private final ErrorInfoProcessor errorInfoProcessor;

    public ExceptionResponseBuilder(OperationService operationBuilder, List<ReturnTypeParser> returnTypeParsers, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils, ErrorInfoProcessor errorInfoProcessor) {
        super(operationBuilder, returnTypeParsers, springDocConfigProperties, propertyResolverUtils);
        this.errorInfoProcessor = errorInfoProcessor;
    }

    public ApiResponses build(Components components, HandlerMethod handlerMethod, Operation operation, MethodAttributes methodAttributes) {
        ApiResponses apiResponses = super.build(components, handlerMethod, operation, methodAttributes);
        Class<?>[] exceptionTypes = handlerMethod.getMethod().getExceptionTypes();
        LinkedHashMap<Integer, TreeSet<ErrorInfo>> errorInfos = new LinkedHashMap<Integer, TreeSet<ErrorInfo>>();
        for (Class<?> exceptionType : exceptionTypes) {
            ErrorInfo errorInfo = this.errorInfoProcessor.getErrorInfo(exceptionType);
            if (errorInfos.containsKey(errorInfo.getStatus())) {
                ((Set)errorInfos.get(errorInfo.getStatus())).add(errorInfo);
                continue;
            }
            errorInfos.put(errorInfo.getStatus(), new TreeSet<ErrorInfo>(Arrays.asList(errorInfo)));
        }
        ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(new AnnotatedType().type(RuntimeErrorInfo.class));
        for (Map.Entry entry : errorInfos.entrySet()) {
            ApiResponse response = new ApiResponse();
            response.setDescription(ErrorMessageSource.getMessage((int)((Integer)entry.getKey()), (String)"Unknown"));
            ObjectSchema schema = new ObjectSchema();
            ArrayList<StringSchema> errorSchemas = new ArrayList<StringSchema>();
            for (ErrorInfo errorInfo : (Set)entry.getValue()) {
                StringSchema ss = new StringSchema();
                String desc = (String)StrUtil.firstNonEmpty((CharSequence[])new String[]{errorInfo.getDoc(), ErrorMessageSource.getMessage((ErrorInfo)errorInfo), "No description"});
                ss.description("\u5e38\u91cf\u503c\uff1a" + errorInfo.getError() + "\uff1b" + desc);
                errorSchemas.add(ss);
            }
            schema.required(resolvedSchema.schema.getRequired());
            schema.properties(new LinkedHashMap(resolvedSchema.schema.getProperties()));
            schema.addProperty("error", new Schema().oneOf(errorSchemas));
            response.setContent(new Content().addMediaType("application/json", new MediaType().schema((Schema)schema)));
            apiResponses.addApiResponse(String.valueOf(entry.getKey()), response);
        }
        return apiResponses;
    }
}

