/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.jany.jooq.field;

import cn.javaer.jany.jackson.Json;
import cn.javaer.jany.jooq.field.CustomFieldUtils;
import java.util.Collections;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Support;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.impl.CustomField;
import org.jooq.impl.DSL;

public class JsonbField<R extends Record, T>
extends CustomField<T>
implements TableField<R, T> {
    private static final long serialVersionUID = -2128410511798819756L;
    private final Table<R> table;
    private final Field<?>[] arguments;

    public JsonbField(String name, DataType<T> type, Field<?> ... argument) {
        super(name, type);
        this.arguments = argument;
        this.table = null;
    }

    public JsonbField(String name, DataType<T> type, Table<R> table) {
        super(name, type);
        this.arguments = null;
        this.table = table;
        CustomFieldUtils.addToFields(table, this);
    }

    public void accept(Context ctx) {
        if (null != this.arguments) {
            ctx.sql(this.getName());
            ctx.sql('(');
            int i = 1;
            for (Field<?> arg : this.arguments) {
                ctx.visit(arg);
                if (i != this.arguments.length) {
                    ctx.sql(',');
                }
                ++i;
            }
            ctx.sql(')');
        } else {
            if (ctx.qualify()) {
                ctx.visit(this.table);
                ctx.sql('.');
            }
            ctx.visit((QueryPart)this.getUnqualifiedName());
        }
    }

    @Support(value={SQLDialect.POSTGRES})
    public Condition jsonbContains(T object) {
        if (object instanceof Field) {
            return this.jsonbContains((Field)object);
        }
        String val = object instanceof String ? (String)object : (object instanceof JSONB ? ((JSONB)object).data() : (object == null ? null : Json.DEFAULT.write(object)));
        return DSL.condition((String)"{0} @> {1}::jsonb", (QueryPart[])new QueryPart[]{this, DSL.val((Object)val, (DataType)this.getDataType())});
    }

    @Support(value={SQLDialect.POSTGRES})
    public Condition jsonbContains(Field<T> field) {
        return DSL.condition((String)"{0} @> {1}", (QueryPart[])new QueryPart[]{this, field});
    }

    @Support(value={SQLDialect.POSTGRES})
    public Condition jsonbContains(String jsonKey, Object jsonValue) {
        String json = Json.DEFAULT.write(Collections.singletonMap(jsonKey, jsonValue));
        return DSL.condition((String)"{0} @> {1}::jsonb", (QueryPart[])new QueryPart[]{this, DSL.val((Object)json, (DataType)this.getDataType())});
    }

    public Table<R> getTable() {
        return this.table;
    }
}

