/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.jany.jooq.condition;

import cn.hutool.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.impl.DSL;

public class ConditionBuilder {
    private final List<Condition> conditions = new ArrayList<Condition>();
    private Condition defaultCondition;

    public ConditionBuilder opt(Condition condition) {
        if (null != condition) {
            this.conditions.add(condition);
        }
        return this;
    }

    public ConditionBuilder opt(boolean isAppend, @NotNull @NotNull Supplier<@NotNull Condition> supplier) {
        if (isAppend) {
            return this.required(supplier);
        }
        return this;
    }

    public ConditionBuilder optNotNull(Field<?> ... fields) {
        if (null != fields && fields.length > 0) {
            if (fields.length == 1) {
                this.conditions.add(fields[0].isNotNull());
            } else {
                Arrays.stream(fields).forEach(field -> this.conditions.add(field.isNotNull()));
            }
        }
        return this;
    }

    public ConditionBuilder opt(@NotNull Supplier<@Nullable Condition> supplier) {
        this.opt(supplier.get());
        return this;
    }

    public ConditionBuilder required(@NotNull Condition condition) {
        this.conditions.add(Objects.requireNonNull(condition));
        return this;
    }

    public ConditionBuilder required(@NotNull @NotNull Supplier<@NotNull Condition> supplier) {
        this.conditions.add(Objects.requireNonNull(supplier.get()));
        return this;
    }

    public <T> ConditionBuilder opt(@NotNull Function<T, Condition> fun, T value) {
        if (ObjectUtil.isEmpty(value)) {
            return this;
        }
        this.conditions.add(fun.apply(value));
        return this;
    }

    public <T1, T2> ConditionBuilder opt(@NotNull BiFunction<T1, T2, Condition> fun, T1 t1, T2 t2) {
        if (ObjectUtil.isEmpty(t1) || ObjectUtil.isEmpty(t2)) {
            return this;
        }
        this.conditions.add(fun.apply(t1, t2));
        return this;
    }

    public <T1, T2, T3> ConditionBuilder opt(@NotNull Function3<T1, T2, T3> fun, T1 t1, T2 t2, T3 t3) {
        if (ObjectUtil.isEmpty(t1) || ObjectUtil.isEmpty(t2) || ObjectUtil.isEmpty(t3)) {
            return this;
        }
        this.conditions.add(fun.apply(t1, t2, t3));
        return this;
    }

    public ConditionBuilder trueConditionIfEmpty() {
        this.defaultCondition = DSL.trueCondition();
        return this;
    }

    public ConditionBuilder falseConditionIfEmpty() {
        this.defaultCondition = DSL.falseCondition();
        return this;
    }

    @Nullable
    public Condition build() {
        if (this.conditions.isEmpty()) {
            return this.defaultCondition;
        }
        Condition condition = this.conditions.get(0);
        int size = this.conditions.size();
        for (int i = 1; i < size; ++i) {
            condition = condition.and(this.conditions.get(i));
        }
        return condition;
    }

    @FunctionalInterface
    public static interface Function3<T1, T2, T3> {
        public Condition apply(T1 var1, T2 var2, T3 var3);
    }
}

