/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.jany.jooq;

import cn.javaer.jany.jackson.Json;
import cn.javaer.jany.jooq.PostGISGeometryConverter;
import cn.javaer.jany.jooq.condition.ContainedInCondition;
import cn.javaer.jany.jooq.field.JsonbField;
import cn.javaer.jany.type.Geometry;
import java.util.Arrays;
import java.util.Collections;
import org.jooq.Condition;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Support;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.util.postgres.PostgresDSL;

public class PGDSL
extends PostgresDSL {
    public static final String JSONB_SQL_TYPE = "jsonb";
    public static DataType<Geometry> GEOMETRY_TYPE = SQLDataType.OTHER.asConvertedDataType((Converter)PostGISGeometryConverter.INSTANCE);

    protected PGDSL() {
    }

    @Support(value={SQLDialect.POSTGRES})
    public static <T> Condition contains(Field<T> field, T value) {
        if (JSONB_SQL_TYPE.equals(field.getDataType().getTypeName())) {
            return DSL.condition((String)"{0} @> {1}::jsonb", (QueryPart[])new QueryPart[]{field, DSL.val((Object)Json.DEFAULT.write(value), (DataType)field.getDataType())});
        }
        return field.contains(value);
    }

    @Support(value={SQLDialect.POSTGRES})
    public static <T> Condition containedIn(Field<T> field, T value) {
        return new ContainedInCondition<T>(field, value);
    }

    @Support(value={SQLDialect.POSTGRES})
    public static Condition jsonbContains(Field<?> jsonField, String jsonKey, Object jsonValue) {
        String json = Json.DEFAULT.write(Collections.singletonMap(jsonKey, jsonValue));
        return DSL.condition((String)"{0} @> {1}::jsonb", (QueryPart[])new QueryPart[]{jsonField, DSL.val((Object)json, (DataType)jsonField.getDataType())});
    }

    @Support(value={SQLDialect.POSTGRES})
    public static JsonbField<Record, JSONB> jsonbObjectAgg(Field<?>[] keyFields, char keySeparator, Field<?> valueField) {
        Field field = Arrays.stream(keyFields).reduce((f1, f2) -> f1.concat(new Field[]{DSL.inline((char)keySeparator), f2})).orElse(null);
        return new JsonbField<Record, JSONB>("jsonb_object_agg", SQLDataType.JSONB, field, valueField);
    }

    @Support(value={SQLDialect.POSTGRES})
    public static <T> Field<T> first(Field<T> field) {
        return DSL.function((String)"first", (DataType)field.getDataType(), (Field[])new Field[]{field});
    }

    @Support(value={SQLDialect.POSTGRES})
    public static Field<Boolean> stContains(Field<Geometry> geomA, Field<Geometry> geomB) {
        return DSL.function((String)"ST_Contains", (DataType)SQLDataType.BOOLEAN, (Field[])new Field[]{geomA, geomB});
    }

    @Support(value={SQLDialect.POSTGRES})
    public static Field<String> stAsGeoJson(Field<Geometry> geom) {
        return DSL.function((String)"ST_AsGeoJSON", (DataType)SQLDataType.LONGVARCHAR, (Field[])new Field[]{geom});
    }
}

