/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.jany.jackson;

import cn.hutool.core.util.StrUtil;
import cn.javaer.jany.jackson.JanyModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class Json {
    public static final Json DEFAULT;
    public static final Json LENIENT;
    public static final Json NON_EMPTY;
    private final ObjectMapper objectMapper;

    public Json(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper);
        this.objectMapper = objectMapper;
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public String write(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    @Nullable
    public <T> T read(String json, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public <T> T read(String json, TypeReference<T> valueTypeRef) {
        if (StrUtil.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(json, valueTypeRef);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public <T> List<T> readList(String json, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)json)) {
            return Collections.emptyList();
        }
        JavaType javaType = this.objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
        try {
            return (List)this.objectMapper.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public JsonNode read(String json) {
        if (StrUtil.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return this.objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    static {
        Module[] modules = new Module[]{new JavaTimeModule(), new Jdk8Module(), new JanyModule()};
        ObjectMapper aDefault = new ObjectMapper();
        aDefault.registerModules(modules);
        DEFAULT = new Json(aDefault);
        ObjectMapper lenient = new ObjectMapper();
        lenient.registerModules(modules);
        lenient.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        LENIENT = new Json(lenient);
        ObjectMapper nonEmpty = new ObjectMapper();
        nonEmpty.registerModules(modules);
        nonEmpty.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        NON_EMPTY = new Json(nonEmpty);
    }
}

