/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.jany.jackson;

import cn.hutool.core.lang.Opt;
import cn.javaer.jany.format.Desensitized;
import cn.javaer.jany.format.StringFormat;
import cn.javaer.jany.util.AnnotationUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;

public class StringFormatSerializer
extends StdSerializer<String>
implements ContextualSerializer {
    private static final long serialVersionUID = 4104322372036119909L;
    public static final StringFormatSerializer INSTANCE = new StringFormatSerializer(null, null);
    private final Desensitized desensitized;
    private final StringFormat stringFormat;

    public StringFormatSerializer(Desensitized desensitized, StringFormat stringFormat) {
        super(String.class);
        this.desensitized = desensitized;
        this.stringFormat = stringFormat;
    }

    public void serialize(String str, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        String value = StringFormat.Formatter.format((String)str, (StringFormat)this.stringFormat);
        if (null == value) {
            jsonGenerator.writeNull();
            return;
        }
        if (null != this.desensitized) {
            value = (String)this.desensitized.type().fn().apply(value);
        }
        jsonGenerator.writeString(value);
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        Iterable annotations = property.getMember().getAllAnnotations().annotations();
        Opt deOpt = AnnotationUtils.findMergedAnnotation(Desensitized.class, (Iterable)annotations);
        Opt sfOpt = AnnotationUtils.findMergedAnnotation(StringFormat.class, (Iterable)annotations);
        Opt sfClazzOpt = AnnotationUtils.findMergedAnnotation(StringFormat.class, (AnnotatedElement)property.getMember().getDeclaringClass());
        return new StringFormatSerializer((Desensitized)deOpt.orElse(null), (StringFormat)sfOpt.orElse((Object)((StringFormat)sfClazzOpt.orElse(null))));
    }
}

