/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.jany.jackson;

import cn.javaer.jany.format.DateTimeFormat;
import cn.javaer.jany.util.AnnotationUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class DateTimeFormatDeserializer
extends JsonDeserializer<LocalDateTime>
implements ContextualDeserializer {
    public static final DateTimeFormatDeserializer INSTANCE = new DateTimeFormatDeserializer();
    private final DateTimeFormat dateTimeFormat;

    protected DateTimeFormatDeserializer() {
        this.dateTimeFormat = null;
    }

    public DateTimeFormatDeserializer(DateTimeFormat dateTimeFormat) {
        Objects.requireNonNull(dateTimeFormat);
        this.dateTimeFormat = dateTimeFormat;
    }

    public LocalDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        Objects.requireNonNull(this.dateTimeFormat);
        if (this.dateTimeFormat.datePattern().length() == parser.getText().length()) {
            LocalDate date = LocalDate.parse(parser.getText(), DateTimeFormatter.ofPattern(this.dateTimeFormat.datePattern()));
            return DateTimeFormat.Formatter.format((LocalDate)date, (DateTimeFormat)this.dateTimeFormat);
        }
        return LocalDateTime.parse(parser.getText(), DateTimeFormatter.ofPattern(this.dateTimeFormat.dateTimePattern()));
    }

    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) {
        Iterable annotations = property.getMember().getAllAnnotations().annotations();
        return (JsonDeserializer)AnnotationUtils.findMergedAnnotation(DateTimeFormat.class, (Iterable)annotations).map(DateTimeFormatDeserializer::new).orElse(null);
    }
}

