/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.jany.jackson;

import cn.hutool.core.util.StrUtil;
import cn.javaer.jany.jackson.DateTimeFormatIntrospector;
import cn.javaer.jany.jackson.JooqJsonbDeserializer;
import cn.javaer.jany.jackson.JooqJsonbSerializer;
import cn.javaer.jany.jackson.JooqRecordSerializer;
import cn.javaer.jany.jackson.KeyValueDeserializer;
import cn.javaer.jany.jackson.KeyValueSerializer;
import cn.javaer.jany.model.KeyValue;
import cn.javaer.jany.util.ReflectUtils;
import cn.javaer.jany.util.TimeUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class Json {
    public static final Json DEFAULT;
    public static final Json LENIENT;
    public static final Json NON_EMPTY;
    public static final SimpleModule MODULE;
    private final ObjectMapper objectMapper;

    public Json(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper);
        this.objectMapper = objectMapper;
    }

    public String write(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    @Nullable
    public <T> T read(String json, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public <T> T read(String json, TypeReference<T> valueTypeRef) {
        if (StrUtil.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(json, valueTypeRef);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public <T> List<T> readList(String json, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)json)) {
            return Collections.emptyList();
        }
        JavaType javaType = this.objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
        try {
            return (List)this.objectMapper.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public JsonNode read(String json) {
        if (StrUtil.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return this.objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    static {
        MODULE = new SimpleModule();
        MODULE.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(TimeUtils.DATE_TIME_FORMATTER));
        MODULE.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(TimeUtils.DATE_FORMATTER));
        MODULE.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(TimeUtils.TIME_FORMATTER));
        MODULE.addSerializer(KeyValue.class, (JsonSerializer)KeyValueSerializer.INSTANCE);
        MODULE.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(TimeUtils.DATE_TIME_FORMATTER));
        MODULE.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(TimeUtils.DATE_FORMATTER));
        MODULE.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(TimeUtils.TIME_FORMATTER));
        MODULE.addDeserializer(KeyValue.class, (JsonDeserializer)KeyValueDeserializer.INSTANCE);
        ReflectUtils.getClass((String)"org.jooq.JSONB").ifPresent(it -> {
            Class clazz = it;
            MODULE.addSerializer(clazz, (JsonSerializer)JooqJsonbSerializer.INSTANCE);
            MODULE.addDeserializer(clazz, (JsonDeserializer)JooqJsonbDeserializer.INSTANCE);
        });
        ReflectUtils.getClass((String)"org.jooq.Record").ifPresent(it -> {
            Class clazz = it;
            MODULE.addSerializer(clazz, (JsonSerializer)JooqRecordSerializer.INSTANCE);
        });
        ObjectMapper aDefault = new ObjectMapper();
        aDefault.setAnnotationIntrospector((AnnotationIntrospector)DateTimeFormatIntrospector.INSTANCE);
        aDefault.registerModule((Module)MODULE);
        DEFAULT = new Json(aDefault);
        ObjectMapper lenient = new ObjectMapper();
        lenient.setAnnotationIntrospector((AnnotationIntrospector)DateTimeFormatIntrospector.INSTANCE);
        lenient.registerModule((Module)MODULE);
        lenient.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        LENIENT = new Json(aDefault);
        ObjectMapper nonEmpty = new ObjectMapper();
        nonEmpty.setAnnotationIntrospector((AnnotationIntrospector)DateTimeFormatIntrospector.INSTANCE);
        nonEmpty.registerModule((Module)MODULE);
        nonEmpty.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        NON_EMPTY = new Json(nonEmpty);
    }
}

