/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.jany.jackson;

import cn.javaer.jany.format.DateMaxTime;
import cn.javaer.jany.format.DateMinTime;
import cn.javaer.jany.format.DateTimeFormat;
import cn.javaer.jany.util.AnnotationUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;

public class DateTimeFormatDeserializer
extends JsonDeserializer<LocalDateTime>
implements ContextualDeserializer {
    private final DateTimeFormat dateTimeFormat;

    protected DateTimeFormatDeserializer() {
        this.dateTimeFormat = null;
    }

    public DateTimeFormatDeserializer(DateTimeFormat dateTimeFormat) {
        Objects.requireNonNull(dateTimeFormat);
        this.dateTimeFormat = dateTimeFormat;
    }

    public LocalDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        Objects.requireNonNull(this.dateTimeFormat);
        if (this.dateTimeFormat.datePattern().length() == parser.getText().length()) {
            LocalDate date = LocalDate.parse(parser.getText(), DateTimeFormatter.ofPattern(this.dateTimeFormat.datePattern()));
            return DateTimeFormat.Conversion.conversion((LocalDate)date, (DateTimeFormat)this.dateTimeFormat);
        }
        return LocalDateTime.parse(parser.getText(), DateTimeFormatter.ofPattern(this.dateTimeFormat.dateTimePattern()));
    }

    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) {
        DateTimeFormat format = (DateTimeFormat)AnnotationUtils.findMergedAnnotation(DateTimeFormat.class, (Annotation[])new Annotation[]{property.getAnnotation(DateTimeFormat.class), property.getAnnotation(DateMinTime.class), property.getAnnotation(DateMaxTime.class)});
        return Optional.ofNullable(format).map(DateTimeFormatDeserializer::new).orElse(null);
    }
}

