/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.jany.jackson;

import cn.javaer.jany.model.KeyValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

public class KeyValueDeserializer
extends StdDeserializer<KeyValue<?>>
implements ContextualDeserializer {
    public static final KeyValueDeserializer INSTANCE = new KeyValueDeserializer();

    public KeyValueDeserializer() {
        super(KeyValue.class);
    }

    public KeyValueDeserializer(JavaType valueType) {
        super(valueType);
    }

    public KeyValue<?> deserialize(JsonParser parser, DeserializationContext cont) throws IOException {
        Object value;
        String key;
        JsonToken token = parser.currentToken();
        if (token != JsonToken.START_OBJECT) {
            cont.handleUnexpectedToken(KeyValue.class, parser);
        }
        if ((key = parser.nextFieldName()) == null) {
            return KeyValue.EMPTY;
        }
        JavaType javaType = this._valueType.containedTypeOrUnknown(0);
        JsonDeserializer deserializer = cont.findRootValueDeserializer(javaType);
        JsonToken jsonToken = parser.nextToken();
        Object object = value = jsonToken != JsonToken.VALUE_NULL ? deserializer.deserialize(parser, cont) : deserializer.getNullValue(cont);
        if (null != parser.nextFieldName()) {
            cont.handleUnexpectedToken(KeyValue.class, parser);
        }
        return KeyValue.of((String)key, (Object)value);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        return new KeyValueDeserializer(ctxt.getContextualType());
    }
}

