/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.aliyun.spring.boot.autoconfigure.sms;

import cn.javaer.aliyun.sms.SmsClient;
import cn.javaer.aliyun.spring.boot.autoconfigure.sms.SmsProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"com.aliyuncs.IAcsClient"})
@EnableConfigurationProperties(value={SmsProperties.class})
public class SmsAutoConfiguration {
    private final SmsProperties smsProperties;

    public SmsAutoConfiguration(SmsProperties smsProperties) {
        this.smsProperties = smsProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SmsClient smsClient() {
        if (this.smsProperties.getTemplates() == null) {
            return new SmsClient(this.smsProperties.getAccessKeyId(), this.smsProperties.getAccessKeySecret());
        }
        return new SmsClient(this.smsProperties.getAccessKeyId(), this.smsProperties.getAccessKeySecret(), this.smsProperties.getTemplates());
    }
}

