/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.monitor;

import com.alibaba.nacos.naming.consistency.persistent.ClusterVersionJudgement;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftCore;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftPeer;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import com.alibaba.nacos.naming.push.PushService;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PerformanceLoggerThread {
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private PushService pushService;
    @Autowired
    private RaftCore raftCore;
    @Autowired
    private ClusterVersionJudgement versionJudgement;
    private static final long PERIOD = 300L;

    @PostConstruct
    public void init() {
        this.start();
    }

    private void start() {
        PerformanceLogTask task = new PerformanceLogTask();
        GlobalExecutor.schedulePerformanceLogger(task, 30L, 300L, TimeUnit.SECONDS);
    }

    @Scheduled(cron="0 0 0 * * ?")
    public void refreshMetrics() {
        this.pushService.setFailedPush(0);
        this.pushService.setTotalPush(0);
        MetricsMonitor.getHttpHealthCheckMonitor().set(0);
        MetricsMonitor.getMysqlHealthCheckMonitor().set(0);
        MetricsMonitor.getTcpHealthCheckMonitor().set(0);
    }

    @Scheduled(cron="0/15 * * * * ?")
    public void collectMetrics() {
        int serviceCount = this.serviceManager.getServiceCount();
        MetricsMonitor.getDomCountMonitor().set(serviceCount);
        int ipCount = this.serviceManager.getInstanceCount();
        MetricsMonitor.getIpCountMonitor().set(ipCount);
        long maxPushCost = this.getMaxPushCost();
        MetricsMonitor.getMaxPushCostMonitor().set(maxPushCost);
        long avgPushCost = this.getAvgPushCost();
        MetricsMonitor.getAvgPushCostMonitor().set(avgPushCost);
        MetricsMonitor.getTotalPushMonitor().set(this.pushService.getTotalPush());
        MetricsMonitor.getFailedPushMonitor().set(this.pushService.getFailedPushCount());
        this.metricsRaftLeader();
    }

    @Deprecated
    private void metricsRaftLeader() {
        if (!this.versionJudgement.allMemberIsNewVersion()) {
            if (this.raftCore.isLeader()) {
                MetricsMonitor.getLeaderStatusMonitor().set(1L);
            } else if (this.raftCore.getPeerSet().local().state == RaftPeer.State.FOLLOWER) {
                MetricsMonitor.getLeaderStatusMonitor().set(0L);
            } else {
                MetricsMonitor.getLeaderStatusMonitor().set(2L);
            }
        }
    }

    private long getMaxPushCost() {
        long max = -1L;
        for (Map.Entry entry : PushService.pushCostMap.entrySet()) {
            if ((Long)entry.getValue() <= max) continue;
            max = (Long)entry.getValue();
        }
        return max;
    }

    private long getAvgPushCost() {
        int size = 0;
        long totalCost = 0L;
        long avgCost = -1L;
        for (Map.Entry entry : PushService.pushCostMap.entrySet()) {
            ++size;
            totalCost += ((Long)entry.getValue()).longValue();
        }
        PushService.pushCostMap.clear();
        if (size > 0 && totalCost > 0L) {
            avgCost = totalCost / (long)size;
        }
        return avgCost;
    }

    class PerformanceLogTask
    implements Runnable {
        PerformanceLogTask() {
        }

        @Override
        public void run() {
            try {
                int serviceCount = PerformanceLoggerThread.this.serviceManager.getServiceCount();
                int ipCount = PerformanceLoggerThread.this.serviceManager.getInstanceCount();
                long maxPushCost = PerformanceLoggerThread.this.getMaxPushCost();
                long avgPushCost = PerformanceLoggerThread.this.getAvgPushCost();
                Loggers.PERFORMANCE_LOG.info("PERFORMANCE:|" + serviceCount + "|" + ipCount + "|" + maxPushCost + "|" + avgPushCost);
            }
            catch (Exception e) {
                Loggers.SRV_LOG.warn("[PERFORMANCE] Exception while print performance log.", (Throwable)e);
            }
        }
    }
}

