/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.utils.IPUtil;
import com.alibaba.nacos.naming.misc.HttpClient;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.Message;
import com.alibaba.nacos.naming.misc.Synchronizer;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.HashMap;
import org.springframework.util.StringUtils;

public class ServerStatusSynchronizer
implements Synchronizer {
    @Override
    public void send(final String serverIP, Message msg) {
        if (StringUtils.isEmpty((Object)serverIP)) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("serverStatus", msg.getData());
        String url = "http://" + serverIP + ":" + EnvUtil.getPort() + EnvUtil.getContextPath() + "/v1/ns" + "/operator/server/status";
        if (IPUtil.containsPort((String)serverIP)) {
            url = "http://" + serverIP + EnvUtil.getContextPath() + "/v1/ns" + "/operator/server/status";
        }
        try {
            HttpClient.asyncHttpGet(url, null, params, new Callback<String>(){

                public void onReceive(RestResult<String> result) {
                    if (!result.ok()) {
                        Loggers.SRV_LOG.warn("[STATUS-SYNCHRONIZE] failed to request serverStatus, remote server: {}", (Object)serverIP);
                    }
                }

                public void onError(Throwable throwable) {
                    Loggers.SRV_LOG.warn("[STATUS-SYNCHRONIZE] failed to request serverStatus, remote server: {}", (Object)serverIP, (Object)throwable);
                }

                public void onCancel() {
                }
            });
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("[STATUS-SYNCHRONIZE] failed to request serverStatus, remote server: {}", (Object)serverIP, (Object)e);
        }
    }

    @Override
    public Message get(String server, String key) {
        return null;
    }
}

