/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.ActionTypes;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.healthcheck.RsInfo;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.pojo.InstanceOperationContext;
import com.alibaba.nacos.naming.pojo.InstanceOperationInfo;
import com.alibaba.nacos.naming.push.ClientInfo;
import com.alibaba.nacos.naming.push.DataSource;
import com.alibaba.nacos.naming.push.PushService;
import com.alibaba.nacos.naming.web.CanDistro;
import com.alibaba.nacos.naming.web.NamingResourceParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.util.VersionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/ns/instance"})
public class InstanceController {
    @Autowired
    private SwitchDomain switchDomain;
    @Autowired
    private PushService pushService;
    @Autowired
    private ServiceManager serviceManager;
    private DataSource pushDataSource = new DataSource(){

        @Override
        public String getData(PushService.PushClient client) {
            ObjectNode result = JacksonUtils.createEmptyJsonNode();
            try {
                result = InstanceController.this.doSrvIpxt(client.getNamespaceId(), client.getServiceName(), client.getAgent(), client.getClusters(), client.getSocketAddr().getAddress().getHostAddress(), 0, "", false, "", "", false);
            }
            catch (Exception e) {
                Loggers.SRV_LOG.warn("PUSH-SERVICE: service is not modified", (Throwable)e);
            }
            result.put("cacheMillis", InstanceController.this.switchDomain.getPushCacheMillis(client.getServiceName()));
            return result.toString();
        }
    };

    @CanDistro
    @PostMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String register(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        Instance instance = this.parseInstance(request);
        this.serviceManager.registerInstance(namespaceId, serviceName, instance);
        return "ok";
    }

    @CanDistro
    @DeleteMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String deregister(HttpServletRequest request) throws Exception {
        Instance instance = this.getIpAddress(request);
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        if (service == null) {
            Loggers.SRV_LOG.warn("remove instance from non-exist service: {}", (Object)serviceName);
            return "ok";
        }
        this.serviceManager.removeInstance(namespaceId, serviceName, instance.isEphemeral(), instance);
        return "ok";
    }

    @CanDistro
    @PutMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String update(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        Instance instance = this.parseInstance(request);
        String agent = WebUtils.getUserAgent((HttpServletRequest)request);
        ClientInfo clientInfo = new ClientInfo(agent);
        if (clientInfo.type == ClientInfo.ClientType.JAVA && clientInfo.version.compareTo(VersionUtil.parseVersion((String)"1.0.0")) >= 0) {
            this.serviceManager.updateInstance(namespaceId, serviceName, instance);
        } else {
            this.serviceManager.registerInstance(namespaceId, serviceName, instance);
        }
        return "ok";
    }

    @CanDistro
    @PutMapping(value={"/metadata/batch"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public ObjectNode batchUpdateInstanceMatadata(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        String consistencyType = WebUtils.optional((HttpServletRequest)request, (String)"consistencyType", (String)"");
        String instances = WebUtils.optional((HttpServletRequest)request, (String)"instances", (String)"");
        List<Instance> targetInstances = this.parseBatchInstances(instances);
        String metadata = WebUtils.required((HttpServletRequest)request, (String)"metadata");
        Map<String, String> targetMetadata = UtilsAndCommons.parseMetadata(metadata);
        List<Instance> operatedInstances = this.batchOperateMetadata(namespaceId, this.buildOperationInfo(serviceName, consistencyType, targetInstances), targetMetadata, "update");
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        ArrayNode ipArray = JacksonUtils.createEmptyArrayNode();
        for (Instance ip : operatedInstances) {
            ipArray.add(ip.getDatumKey() + ":" + (ip.isEphemeral() ? "ephemeral" : "persist"));
        }
        result.replace("updated", (JsonNode)ipArray);
        return result;
    }

    @CanDistro
    @DeleteMapping(value={"/metadata/batch"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public ObjectNode batchDeleteInstanceMatadata(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        String consistencyType = WebUtils.optional((HttpServletRequest)request, (String)"consistencyType", (String)"");
        String instances = WebUtils.optional((HttpServletRequest)request, (String)"instances", (String)"");
        List<Instance> targetInstances = this.parseBatchInstances(instances);
        String metadata = WebUtils.required((HttpServletRequest)request, (String)"metadata");
        Map<String, String> targetMetadata = UtilsAndCommons.parseMetadata(metadata);
        List<Instance> operatedInstances = this.batchOperateMetadata(namespaceId, this.buildOperationInfo(serviceName, consistencyType, targetInstances), targetMetadata, "remove");
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        ArrayNode ipArray = JacksonUtils.createEmptyArrayNode();
        for (Instance ip : operatedInstances) {
            ipArray.add(ip.getDatumKey() + ":" + (ip.isEphemeral() ? "ephemeral" : "persist"));
        }
        result.replace("updated", (JsonNode)ipArray);
        return result;
    }

    private InstanceOperationInfo buildOperationInfo(String serviceName, String consistencyType, List<Instance> instances) {
        if (!CollectionUtils.isEmpty(instances)) {
            for (Instance instance : instances) {
                if (!StringUtils.isBlank((CharSequence)instance.getClusterName())) continue;
                instance.setClusterName("DEFAULT");
            }
        }
        return new InstanceOperationInfo(serviceName, consistencyType, instances);
    }

    private List<Instance> parseBatchInstances(String instances) {
        try {
            return (List)JacksonUtils.toObj((String)instances, (TypeReference)new TypeReference<List<Instance>>(){});
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("UPDATE-METADATA: Param 'instances' is illegal, ignore this operation", (Throwable)e);
            return null;
        }
    }

    private List<Instance> batchOperateMetadata(String namespace, InstanceOperationInfo instanceOperationInfo, Map<String, String> metadata, String action) {
        Function<InstanceOperationContext, List<Instance>> operateFunction = instanceOperationContext -> {
            try {
                return this.serviceManager.updateMetadata(instanceOperationContext.getNamespace(), instanceOperationContext.getServiceName(), instanceOperationContext.getEphemeral(), action, instanceOperationContext.getAll(), instanceOperationContext.getInstances(), metadata);
            }
            catch (NacosException e) {
                Loggers.SRV_LOG.warn("UPDATE-METADATA: updateMetadata failed", (Throwable)e);
                return new ArrayList();
            }
        };
        return this.serviceManager.batchOperate(namespace, instanceOperationInfo, operateFunction);
    }

    @CanDistro
    @PatchMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String patch(HttpServletRequest request) throws Exception {
        String enabledString;
        String healthy;
        String weight;
        String app;
        Instance instance;
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        String ip = WebUtils.required((HttpServletRequest)request, (String)"ip");
        String port = WebUtils.required((HttpServletRequest)request, (String)"port");
        String cluster = WebUtils.optional((HttpServletRequest)request, (String)"clusterName", (String)"");
        if (StringUtils.isBlank((CharSequence)cluster)) {
            cluster = WebUtils.optional((HttpServletRequest)request, (String)"cluster", (String)"DEFAULT");
        }
        if ((instance = this.serviceManager.getInstance(namespaceId, serviceName, cluster, ip, Integer.parseInt(port))) == null) {
            throw new IllegalArgumentException("instance not found");
        }
        String metadata = WebUtils.optional((HttpServletRequest)request, (String)"metadata", (String)"");
        if (StringUtils.isNotBlank((CharSequence)metadata)) {
            instance.setMetadata(UtilsAndCommons.parseMetadata(metadata));
        }
        if (StringUtils.isNotBlank((CharSequence)(app = WebUtils.optional((HttpServletRequest)request, (String)"app", (String)"")))) {
            instance.setApp(app);
        }
        if (StringUtils.isNotBlank((CharSequence)(weight = WebUtils.optional((HttpServletRequest)request, (String)"weight", (String)"")))) {
            instance.setWeight(Double.parseDouble(weight));
        }
        if (StringUtils.isNotBlank((CharSequence)(healthy = WebUtils.optional((HttpServletRequest)request, (String)"healthy", (String)"")))) {
            instance.setHealthy(BooleanUtils.toBoolean((String)healthy));
        }
        if (StringUtils.isNotBlank((CharSequence)(enabledString = WebUtils.optional((HttpServletRequest)request, (String)"enabled", (String)"")))) {
            instance.setEnabled(BooleanUtils.toBoolean((String)enabledString));
        }
        instance.setLastBeat(System.currentTimeMillis());
        instance.validate();
        this.serviceManager.updateInstance(namespaceId, serviceName, instance);
        return "ok";
    }

    @GetMapping(value={"/list"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    public ObjectNode list(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        String agent = WebUtils.getUserAgent((HttpServletRequest)request);
        String clusters = WebUtils.optional((HttpServletRequest)request, (String)"clusters", (String)"");
        String clientIP = WebUtils.optional((HttpServletRequest)request, (String)"clientIP", (String)"");
        int udpPort = Integer.parseInt(WebUtils.optional((HttpServletRequest)request, (String)"udpPort", (String)"0"));
        String env = WebUtils.optional((HttpServletRequest)request, (String)"env", (String)"");
        boolean isCheck = Boolean.parseBoolean(WebUtils.optional((HttpServletRequest)request, (String)"isCheck", (String)"false"));
        String app = WebUtils.optional((HttpServletRequest)request, (String)"app", (String)"");
        String tenant = WebUtils.optional((HttpServletRequest)request, (String)"tid", (String)"");
        boolean healthyOnly = Boolean.parseBoolean(WebUtils.optional((HttpServletRequest)request, (String)"healthyOnly", (String)"false"));
        return this.doSrvIpxt(namespaceId, serviceName, agent, clusters, clientIP, udpPort, env, isCheck, app, tenant, healthyOnly);
    }

    @GetMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    public ObjectNode detail(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        String cluster = WebUtils.optional((HttpServletRequest)request, (String)"clusterName", (String)"DEFAULT");
        String ip = WebUtils.required((HttpServletRequest)request, (String)"ip");
        int port = Integer.parseInt(WebUtils.required((HttpServletRequest)request, (String)"port"));
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        if (service == null) {
            throw new NacosException(404, "no service " + serviceName + " found!");
        }
        ArrayList<String> clusters = new ArrayList<String>();
        clusters.add(cluster);
        List<Instance> ips = service.allIPs(clusters);
        if (ips == null || ips.isEmpty()) {
            throw new NacosException(404, "no ips found for cluster " + cluster + " in service " + serviceName);
        }
        for (Instance instance : ips) {
            if (!instance.getIp().equals(ip) || instance.getPort() != port) continue;
            ObjectNode result = JacksonUtils.createEmptyJsonNode();
            result.put("service", serviceName);
            result.put("ip", ip);
            result.put("port", port);
            result.put("clusterName", cluster);
            result.put("weight", instance.getWeight());
            result.put("healthy", instance.isHealthy());
            result.put("instanceId", instance.getInstanceId());
            result.set("metadata", JacksonUtils.transferToJsonNode((Object)instance.getMetadata()));
            return result;
        }
        throw new NacosException(404, "no matched ip found!");
    }

    @CanDistro
    @PutMapping(value={"/beat"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public ObjectNode beat(HttpServletRequest request) throws Exception {
        Service service;
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.put("clientBeatInterval", this.switchDomain.getClientBeatInterval());
        String beat = WebUtils.optional((HttpServletRequest)request, (String)"beat", (String)"");
        RsInfo clientBeat = null;
        if (StringUtils.isNotBlank((CharSequence)beat)) {
            clientBeat = (RsInfo)JacksonUtils.toObj((String)beat, RsInfo.class);
        }
        String clusterName = WebUtils.optional((HttpServletRequest)request, (String)"clusterName", (String)"DEFAULT");
        String ip = WebUtils.optional((HttpServletRequest)request, (String)"ip", (String)"");
        int port = Integer.parseInt(WebUtils.optional((HttpServletRequest)request, (String)"port", (String)"0"));
        if (clientBeat != null) {
            if (StringUtils.isNotBlank((CharSequence)clientBeat.getCluster())) {
                clusterName = clientBeat.getCluster();
            } else {
                clientBeat.setCluster(clusterName);
            }
            ip = clientBeat.getIp();
            port = clientBeat.getPort();
        }
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        NamingUtils.checkServiceNameFormat((String)serviceName);
        Loggers.SRV_LOG.debug("[CLIENT-BEAT] full arguments: beat: {}, serviceName: {}", (Object)clientBeat, (Object)serviceName);
        Instance instance = this.serviceManager.getInstance(namespaceId, serviceName, clusterName, ip, port);
        if (instance == null) {
            if (clientBeat == null) {
                result.put("code", 20404);
                return result;
            }
            Loggers.SRV_LOG.warn("[CLIENT-BEAT] The instance has been removed for health mechanism, perform data compensation operations, beat: {}, serviceName: {}", (Object)clientBeat, (Object)serviceName);
            instance = new Instance();
            instance.setPort(clientBeat.getPort());
            instance.setIp(clientBeat.getIp());
            instance.setWeight(clientBeat.getWeight());
            instance.setMetadata(clientBeat.getMetadata());
            instance.setClusterName(clusterName);
            instance.setServiceName(serviceName);
            instance.setInstanceId(instance.getInstanceId());
            instance.setEphemeral(clientBeat.isEphemeral());
            this.serviceManager.registerInstance(namespaceId, serviceName, instance);
        }
        if ((service = this.serviceManager.getService(namespaceId, serviceName)) == null) {
            throw new NacosException(500, "service not found: " + serviceName + "@" + namespaceId);
        }
        if (clientBeat == null) {
            clientBeat = new RsInfo();
            clientBeat.setIp(ip);
            clientBeat.setPort(port);
            clientBeat.setCluster(clusterName);
        }
        service.processClientBeat(clientBeat);
        result.put("code", 10200);
        if (instance.containsMetadata("preserved.heart.beat.interval")) {
            result.put("clientBeatInterval", instance.getInstanceHeartBeatInterval());
        }
        result.put("lightBeatEnabled", this.switchDomain.isLightBeatEnabled());
        return result;
    }

    @RequestMapping(value={"/statuses"})
    public ObjectNode listWithHealthStatus(@RequestParam String key) throws NacosException {
        String serviceName;
        String namespaceId;
        if (key.contains("##")) {
            namespaceId = key.split("##")[0];
            serviceName = key.split("##")[1];
        } else {
            namespaceId = "public";
            serviceName = key;
        }
        NamingUtils.checkServiceNameFormat((String)serviceName);
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        if (service == null) {
            throw new NacosException(404, "service: " + serviceName + " not found.");
        }
        List<Instance> ips = service.allIPs();
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        ArrayNode ipArray = JacksonUtils.createEmptyArrayNode();
        for (Instance ip : ips) {
            ipArray.add(ip.toIpAddr() + "_" + ip.isHealthy());
        }
        result.replace("ips", (JsonNode)ipArray);
        return result;
    }

    private Instance parseInstance(HttpServletRequest request) throws Exception {
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        String app = WebUtils.optional((HttpServletRequest)request, (String)"app", (String)"DEFAULT");
        Instance instance = this.getIpAddress(request);
        instance.setApp(app);
        instance.setServiceName(serviceName);
        instance.setInstanceId(instance.generateInstanceId());
        instance.setLastBeat(System.currentTimeMillis());
        String metadata = WebUtils.optional((HttpServletRequest)request, (String)"metadata", (String)"");
        if (StringUtils.isNotEmpty((CharSequence)metadata)) {
            instance.setMetadata(UtilsAndCommons.parseMetadata(metadata));
        }
        instance.validate();
        return instance;
    }

    private Instance getIpAddress(HttpServletRequest request) {
        String enabledString = WebUtils.optional((HttpServletRequest)request, (String)"enabled", (String)"");
        boolean enabled = StringUtils.isBlank((CharSequence)enabledString) ? BooleanUtils.toBoolean((String)WebUtils.optional((HttpServletRequest)request, (String)"enable", (String)"true")) : BooleanUtils.toBoolean((String)enabledString);
        String weight = WebUtils.optional((HttpServletRequest)request, (String)"weight", (String)"1");
        boolean healthy = BooleanUtils.toBoolean((String)WebUtils.optional((HttpServletRequest)request, (String)"healthy", (String)"true"));
        Instance instance = this.getBasicIpAddress(request);
        instance.setWeight(Double.parseDouble(weight));
        instance.setHealthy(healthy);
        instance.setEnabled(enabled);
        return instance;
    }

    private Instance getBasicIpAddress(HttpServletRequest request) {
        String ip = WebUtils.required((HttpServletRequest)request, (String)"ip");
        String port = WebUtils.required((HttpServletRequest)request, (String)"port");
        String cluster = WebUtils.optional((HttpServletRequest)request, (String)"clusterName", (String)"");
        if (StringUtils.isBlank((CharSequence)cluster)) {
            cluster = WebUtils.optional((HttpServletRequest)request, (String)"cluster", (String)"DEFAULT");
        }
        boolean ephemeral = BooleanUtils.toBoolean((String)WebUtils.optional((HttpServletRequest)request, (String)"ephemeral", (String)String.valueOf(this.switchDomain.isDefaultInstanceEphemeral())));
        Instance instance = new Instance();
        instance.setPort(Integer.parseInt(port));
        instance.setIp(ip);
        instance.setEphemeral(ephemeral);
        instance.setClusterName(cluster);
        return instance;
    }

    private void checkIfDisabled(Service service) throws Exception {
        if (!service.getEnabled().booleanValue()) {
            throw new Exception("service is disabled now.");
        }
    }

    public ObjectNode doSrvIpxt(String namespaceId, String serviceName, String agent, String clusters, String clientIP, int udpPort, String env, boolean isCheck, String app, String tid, boolean healthyOnly) throws Exception {
        ClientInfo clientInfo = new ClientInfo(agent);
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        long cacheMillis = this.switchDomain.getDefaultCacheMillis();
        try {
            if (udpPort > 0 && this.pushService.canEnablePush(agent)) {
                this.pushService.addClient(namespaceId, serviceName, clusters, agent, new InetSocketAddress(clientIP, udpPort), this.pushDataSource, tid, app);
                cacheMillis = this.switchDomain.getPushCacheMillis(serviceName);
            }
        }
        catch (Exception e) {
            Loggers.SRV_LOG.error("[NACOS-API] failed to added push client {}, {}:{}", new Object[]{clientInfo, clientIP, udpPort, e});
            cacheMillis = this.switchDomain.getDefaultCacheMillis();
        }
        if (service == null) {
            if (Loggers.SRV_LOG.isDebugEnabled()) {
                Loggers.SRV_LOG.debug("no instance to serve for service: {}", (Object)serviceName);
            }
            result.put("name", serviceName);
            result.put("clusters", clusters);
            result.put("cacheMillis", cacheMillis);
            result.replace("hosts", (JsonNode)JacksonUtils.createEmptyArrayNode());
            return result;
        }
        this.checkIfDisabled(service);
        List<Instance> srvedIPs = service.srvIPs(Arrays.asList(StringUtils.split((String)clusters, (String)",")));
        if (service.getSelector() != null && StringUtils.isNotBlank((CharSequence)clientIP)) {
            srvedIPs = service.getSelector().select(clientIP, srvedIPs);
        }
        if (CollectionUtils.isEmpty(srvedIPs)) {
            if (Loggers.SRV_LOG.isDebugEnabled()) {
                Loggers.SRV_LOG.debug("no instance to serve for service: {}", (Object)serviceName);
            }
            if (clientInfo.type == ClientInfo.ClientType.JAVA && clientInfo.version.compareTo(VersionUtil.parseVersion((String)"1.0.0")) >= 0) {
                result.put("dom", serviceName);
            } else {
                result.put("dom", NamingUtils.getServiceName((String)serviceName));
            }
            result.put("name", serviceName);
            result.put("cacheMillis", cacheMillis);
            result.put("lastRefTime", System.currentTimeMillis());
            result.put("checksum", service.getChecksum());
            result.put("useSpecifiedURL", false);
            result.put("clusters", clusters);
            result.put("env", env);
            result.set("hosts", (JsonNode)JacksonUtils.createEmptyArrayNode());
            result.set("metadata", JacksonUtils.transferToJsonNode((Object)service.getMetadata()));
            return result;
        }
        HashMap ipMap = new HashMap(2);
        ipMap.put(Boolean.TRUE, new ArrayList());
        ipMap.put(Boolean.FALSE, new ArrayList());
        for (Instance ip : srvedIPs) {
            ((List)ipMap.get(ip.isHealthy())).add(ip);
        }
        if (isCheck) {
            result.put("reachProtectThreshold", false);
        }
        double threshold = service.getProtectThreshold();
        if ((double)((float)((List)ipMap.get(Boolean.TRUE)).size() / (float)srvedIPs.size()) <= threshold) {
            Loggers.SRV_LOG.warn("protect threshold reached, return all ips, service: {}", (Object)serviceName);
            if (isCheck) {
                result.put("reachProtectThreshold", true);
            }
            ((List)ipMap.get(Boolean.TRUE)).addAll((Collection)ipMap.get(Boolean.FALSE));
            ((List)ipMap.get(Boolean.FALSE)).clear();
        }
        if (isCheck) {
            result.put("protectThreshold", service.getProtectThreshold());
            result.put("reachLocalSiteCallThreshold", false);
            return JacksonUtils.createEmptyJsonNode();
        }
        ArrayNode hosts = JacksonUtils.createEmptyArrayNode();
        for (Map.Entry entry : ipMap.entrySet()) {
            List ips = (List)entry.getValue();
            if (healthyOnly && !((Boolean)entry.getKey()).booleanValue()) continue;
            for (Instance instance : ips) {
                if (!instance.isEnabled()) continue;
                ObjectNode ipObj = JacksonUtils.createEmptyJsonNode();
                ipObj.put("ip", instance.getIp());
                ipObj.put("port", instance.getPort());
                ipObj.put("valid", (Boolean)entry.getKey());
                ipObj.put("healthy", (Boolean)entry.getKey());
                ipObj.put("marked", instance.isMarked());
                ipObj.put("instanceId", instance.getInstanceId());
                ipObj.set("metadata", JacksonUtils.transferToJsonNode((Object)instance.getMetadata()));
                ipObj.put("enabled", instance.isEnabled());
                ipObj.put("weight", instance.getWeight());
                ipObj.put("clusterName", instance.getClusterName());
                if (clientInfo.type == ClientInfo.ClientType.JAVA && clientInfo.version.compareTo(VersionUtil.parseVersion((String)"1.0.0")) >= 0) {
                    ipObj.put("serviceName", instance.getServiceName());
                } else {
                    ipObj.put("serviceName", NamingUtils.getServiceName((String)instance.getServiceName()));
                }
                ipObj.put("ephemeral", instance.isEphemeral());
                hosts.add((JsonNode)ipObj);
            }
        }
        result.replace("hosts", (JsonNode)hosts);
        if (clientInfo.type == ClientInfo.ClientType.JAVA && clientInfo.version.compareTo(VersionUtil.parseVersion((String)"1.0.0")) >= 0) {
            result.put("dom", serviceName);
        } else {
            result.put("dom", NamingUtils.getServiceName((String)serviceName));
        }
        result.put("name", serviceName);
        result.put("cacheMillis", cacheMillis);
        result.put("lastRefTime", System.currentTimeMillis());
        result.put("checksum", service.getChecksum());
        result.put("useSpecifiedURL", false);
        result.put("clusters", clusters);
        result.put("env", env);
        result.replace("metadata", JacksonUtils.transferToJsonNode((Object)service.getMetadata()));
        return result;
    }
}

