/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent.impl;

import com.alibaba.nacos.common.utils.Objects;
import com.alibaba.nacos.consistency.snapshot.LocalFileMeta;
import com.alibaba.nacos.consistency.snapshot.Reader;
import com.alibaba.nacos.consistency.snapshot.SnapshotOperation;
import com.alibaba.nacos.consistency.snapshot.Writer;
import com.alibaba.nacos.core.distributed.raft.utils.RaftExecutor;
import com.alibaba.nacos.core.storage.kv.KvStorage;
import com.alibaba.nacos.core.utils.TimerContext;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.sys.utils.DiskUtils;
import com.alipay.sofa.jraft.util.CRC64;
import java.nio.file.Paths;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.zip.Checksum;
import org.slf4j.Logger;

public class NamingSnapshotOperation
implements SnapshotOperation {
    private static final String NAMING_SNAPSHOT_SAVE = NamingSnapshotOperation.class.getSimpleName() + ".SAVE";
    private static final String NAMING_SNAPSHOT_LOAD = NamingSnapshotOperation.class.getSimpleName() + ".LOAD";
    private final String snapshotDir = "naming_persistent";
    private final String snapshotArchive = "naming_persistent.zip";
    private final String checkSumKey = "checkSum";
    private final KvStorage storage;
    private final ReentrantReadWriteLock.WriteLock writeLock;

    public NamingSnapshotOperation(KvStorage storage, ReentrantReadWriteLock lock) {
        this.storage = storage;
        this.writeLock = lock.writeLock();
    }

    public void onSnapshotSave(Writer writer, BiConsumer<Boolean, Throwable> callFinally) {
        RaftExecutor.doSnapshot(() -> {
            TimerContext.start((String)NAMING_SNAPSHOT_SAVE);
            ReentrantReadWriteLock.WriteLock lock = this.writeLock;
            lock.lock();
            try {
                String writePath = writer.getPath();
                String parentPath = Paths.get(writePath, "naming_persistent").toString();
                DiskUtils.deleteDirectory((String)parentPath);
                DiskUtils.forceMkdir((String)parentPath);
                this.storage.doSnapshot(parentPath);
                String outputFile = Paths.get(writePath, "naming_persistent.zip").toString();
                CRC64 checksum = new CRC64();
                DiskUtils.compress((String)writePath, (String)"naming_persistent", (String)outputFile, (Checksum)checksum);
                DiskUtils.deleteDirectory((String)parentPath);
                LocalFileMeta meta = new LocalFileMeta();
                meta.append((Object)"checkSum", (Object)Long.toHexString(checksum.getValue()));
                callFinally.accept(writer.addFile("naming_persistent.zip", meta), null);
            }
            catch (Throwable t) {
                Loggers.RAFT.error("Fail to compress snapshot, path={}, file list={}, {}.", new Object[]{writer.getPath(), writer.listFiles(), t});
                callFinally.accept(false, t);
            }
            finally {
                lock.unlock();
                TimerContext.end((String)NAMING_SNAPSHOT_SAVE, (Logger)Loggers.RAFT);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onSnapshotLoad(Reader reader) {
        String readerPath = reader.getPath();
        String sourceFile = Paths.get(readerPath, "naming_persistent.zip").toString();
        TimerContext.start((String)NAMING_SNAPSHOT_LOAD);
        ReentrantReadWriteLock.WriteLock lock = this.writeLock;
        lock.lock();
        try {
            CRC64 checksum = new CRC64();
            DiskUtils.decompress((String)sourceFile, (String)readerPath, (Checksum)checksum);
            LocalFileMeta fileMeta = reader.getFileMeta("naming_persistent.zip");
            if (fileMeta.getFileMeta().containsKey("checkSum") && !Objects.equals((Object)Long.toHexString(checksum.getValue()), (Object)fileMeta.get("checkSum"))) {
                throw new IllegalArgumentException("Snapshot checksum failed");
            }
            String loadPath = Paths.get(readerPath, "naming_persistent").toString();
            this.storage.snapshotLoad(loadPath);
            Loggers.RAFT.info("snapshot load from : {}", (Object)loadPath);
            DiskUtils.deleteDirectory((String)loadPath);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            Loggers.RAFT.error("Fail to load snapshot, path={}, file list={}, {}.", new Object[]{Paths.get(readerPath, "naming_persistent").toString(), reader.listFiles(), t});
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
            TimerContext.end((String)NAMING_SNAPSHOT_LOAD, (Logger)Loggers.RAFT);
        }
    }
}

