package cn.jasonone.ueditor.upload;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

import org.apache.commons.io.FileUtils;

import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.AppInfo;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.MultiState;
import com.baidu.ueditor.define.State;

public class LocationFileStorage implements UeditorUpload {
	private Map<String, Object> config;
	private String rootPath;
	private String[] allowFiles;
	private String dir;
	private Integer count;

	public LocationFileStorage() {
	}

	/**
	 * 检测用于对于path是否拥有写权限
	 * 
	 * @param savePath 保存路径
	 * @return 处理结果
	 */
	public BaseState validFile(String savePath) {
		File file = new File(rootPath, savePath);
		File parentPath = file.getParentFile();

		if ((!parentPath.exists()) && (!parentPath.mkdirs())) {
			return new BaseState(false, AppInfo.FAILED_CREATE_FILE);
		}

		if (!parentPath.canWrite()) {
			return new BaseState(false, AppInfo.PERMISSION_DENIED);
		}

		return new BaseState(true);
	}

	public void save(File file, String rootPath, String path) throws IOException {
		FileUtils.moveFile(file, new File(rootPath, path));
	}

	public void save(byte[] data, String rootPath, String savePath) throws IOException {
		BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(rootPath, savePath)));
		bos.write(data);
		bos.flush();
		bos.close();
	}

	@Override
	public State listFile(int index) {
		File dir = new File(this.dir);
		State state = null;

		if (!dir.exists()) {
			return new BaseState(false, AppInfo.NOT_EXIST);
		}

		if (!dir.isDirectory()) {
			return new BaseState(false, AppInfo.NOT_DIRECTORY);
		}
		if(this.allowFiles == null) {
			this.allowFiles=this.getAllowFiles(this.config.get("allowFiles"));
		}
		Collection<File> list = FileUtils.listFiles(dir, this.allowFiles, true);

		if (index < 0 || index > list.size()) {
			state = new MultiState(true);
		} else {
			Object[] fileList = Arrays.copyOfRange(list.toArray(), index, index + this.count);
			state = this.getState(fileList);
		}

		state.putInfo("start", index);
		state.putInfo("total", list.size());

		return state;
	}

	@Override
	public MultiState getState(Object[] files) {
		MultiState state = new MultiState(true);
		BaseState fileState = null;

		File file = null;

		for (Object obj : files) {
			if (obj == null) {
				break;
			}
			file = (File) obj;
			fileState = new BaseState(true);
			fileState.putInfo("url", this.getPath(PathFormat.format(file.getAbsolutePath())));
			state.addState(fileState);
		}
		return state;
	}

	@Override
	public String getPath(String filePath) {
		return filePath.replace(this.rootPath, "");
	}

	@Override
	public void setConfig(Map<String, Object> conf) {
		this.config = conf;
		this.rootPath = (String) conf.get("rootPath");
		this.dir = this.rootPath + (String) conf.get("dir");
		this.count = (Integer) conf.get("count");
	}
}
