package cn.jasonone.ueditor.upload;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.io.FileUtils;

import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.AppInfo;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.MultiState;
import com.baidu.ueditor.define.State;

public interface FileManager {
	/**
	 * 获取文件列表
	 * 
	 * @param index 文件索引
	 * @return 返回处理结果
	 */
	public State listFile(int index);

	/**
	 * 获得状态集合
	 * 
	 * @param files	文件列表
	 * @return 状态集合
	 */
	public MultiState getState(Object[] files);

	/**
	 * 将文件路径转换为URL访问路径
	 * 
	 * @param filePath 文件绝对路径
	 * @return 文件的URL访问路径
	 */
	public String getPath(String filePath);

	default String[] getAllowFiles(Object fileExt) {

		String[] exts = null;
		String ext = null;

		if (fileExt == null) {
			return new String[0];
		}

		exts = (String[]) fileExt;

		for (int i = 0, len = exts.length; i < len; i++) {

			ext = exts[i];
			exts[i] = ext.replace(".", "");

		}

		return exts;

	}
}
