package cn.jasonone.ueditor;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

import cn.jasonone.ueditor.servlet.UeditorController;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Configuration
@EnableConfigurationProperties(UeditorProperties.class)
public class UeditorAutoConfiguration {
	/**
	 * 默认服务接口名称
	 */
	private static final String DEFAULT_SERVER_URL = "/ueditor/jsp/controller";
	@Autowired
	private UeditorProperties properties;

	@Bean
	public ServletRegistrationBean<UeditorController> ueditorController() {
		UeditorController uc = new UeditorController();
		uc.setProperties(properties);
		ServletRegistrationBean<UeditorController> srb = new ServletRegistrationBean<>(uc);
		String serverUrl = StringUtils.isEmpty(properties.getServerUrl()) ? DEFAULT_SERVER_URL
				: properties.getServerUrl();
		log.info("Ueditor Server Url: [{}]", serverUrl);
		srb.addUrlMappings(serverUrl);
		return srb;
	}
}
