package cn.jasonone.ueditor.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;

import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

import cn.jasonone.ueditor.ActionEnter;
import cn.jasonone.ueditor.UeditorProperties;
import cn.jasonone.ueditor.upload.StorageManager;
import cn.jasonone.ueditor.upload.UeditorUpload;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Data
@Slf4j
public class UeditorController extends HttpServlet {
	/**
	 * 默认资源目录
	 */
	private static String DEFAULT_ROOT_PATH = "classpath:/static";
	private UeditorProperties properties;
	private String rootPath;
	private UeditorUpload upload;

	@Override
	protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		req.setCharacterEncoding("UTF-8");
		resp.setContentType("text/html;charset=UTF-8");
		resp.getWriter().write(new ActionEnter(new StorageManager(), req, rootPath).exec());
	}

	private String paserPath(String path) throws FileNotFoundException {
		if (StringUtils.isEmpty(path))
			return path;
		if (StringUtils.startsWithIgnoreCase(path, "classpath:")) {
			path = path.substring(10);
			return ResourceUtils.getFile("classpath:") + path;
		}
		return path;
	}

	@Override
	public void init() throws ServletException {
		rootPath = DEFAULT_ROOT_PATH;
		if (!StringUtils.isEmpty(properties.getRootPath())) {
			rootPath = properties.getRootPath();
		}
		try {
			rootPath = paserPath(rootPath);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		log.info("Ueditor root-path:[{}]", rootPath);
		Class<? extends UeditorUpload> upload2 = properties.getUpload();
		try {
			upload = upload2.newInstance();
		} catch (InstantiationException | IllegalAccessException e) {
			e.printStackTrace();
		}
	}
}
