package cn.jasonone.ueditor;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

import cn.jasonone.ueditor.upload.LocationFileStorage;
import cn.jasonone.ueditor.upload.UeditorUpload;
import lombok.Data;
@Configuration
@ConfigurationProperties("ue")
@Primary
@Data
public class UeditorProperties {
	/**
	 * 上传文件存放目录
	 */
	private String rootPath="classpath:/static";
	/**
	 * 统一服务接口名称配置,config.json存放目录为服务接口的上级目录 例: rootPath: classpath:/static
	 * serverUrl: /ueditor/controller 则config.json存放目录为:
	 * classpath:/static/ueditor/config.json
	 */
	private String serverUrl="/ueditor/jsp/controller";
	/**
	 * 文件上传持久化接口,默认为保存到本地磁盘
	 */
	private Class<? extends UeditorUpload> upload = LocationFileStorage.class;
}
