/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.ueditor.servlet;

import cn.jasonone.ueditor.ActionEnter;
import cn.jasonone.ueditor.UeditorProperties;
import cn.jasonone.ueditor.upload.StorageManager;
import cn.jasonone.ueditor.upload.UeditorUpload;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class UeditorController
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(UeditorController.class);
    private static String DEFAULT_ROOT_PATH = "classpath:/static";
    private UeditorProperties properties;
    private String rootPath;
    private UeditorUpload upload;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        resp.setContentType("text/html;charset=UTF-8");
        resp.getWriter().write(new ActionEnter(new StorageManager(), req, this.rootPath).exec());
    }

    private String paserPath(String path) throws FileNotFoundException {
        if (StringUtils.isEmpty((Object)path)) {
            return path;
        }
        if (StringUtils.startsWithIgnoreCase((String)path, (String)"classpath:")) {
            path = path.substring(10);
            return ResourceUtils.getFile((String)"classpath:") + path;
        }
        return path;
    }

    public void init() throws ServletException {
        this.rootPath = DEFAULT_ROOT_PATH;
        if (!StringUtils.isEmpty((Object)this.properties.getRootPath())) {
            this.rootPath = this.properties.getRootPath();
        }
        try {
            this.rootPath = this.paserPath(this.rootPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        log.info("Ueditor root-path:[{}]", (Object)this.rootPath);
        Class<? extends UeditorUpload> upload2 = this.properties.getUpload();
        try {
            this.upload = upload2.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public UeditorProperties getProperties() {
        return this.properties;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public UeditorUpload getUpload() {
        return this.upload;
    }

    public void setProperties(UeditorProperties properties) {
        this.properties = properties;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setUpload(UeditorUpload upload) {
        this.upload = upload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UeditorController)) {
            return false;
        }
        UeditorController other = (UeditorController)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UeditorProperties this$properties = this.getProperties();
        UeditorProperties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$rootPath = this.getRootPath();
        String other$rootPath = other.getRootPath();
        if (this$rootPath == null ? other$rootPath != null : !this$rootPath.equals(other$rootPath)) {
            return false;
        }
        UeditorUpload this$upload = this.getUpload();
        UeditorUpload other$upload = other.getUpload();
        return !(this$upload == null ? other$upload != null : !this$upload.equals(other$upload));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UeditorController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UeditorProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $rootPath = this.getRootPath();
        result = result * 59 + ($rootPath == null ? 43 : $rootPath.hashCode());
        UeditorUpload $upload = this.getUpload();
        result = result * 59 + ($upload == null ? 43 : $upload.hashCode());
        return result;
    }

    public String toString() {
        return "UeditorController(properties=" + this.getProperties() + ", rootPath=" + this.getRootPath() + ", upload=" + this.getUpload() + ")";
    }
}

