/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.ueditor;

import cn.jasonone.ueditor.UeditorProperties;
import cn.jasonone.ueditor.servlet.UeditorController;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={UeditorProperties.class})
public class UeditorAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(UeditorAutoConfiguration.class);
    private static final String DEFAULT_SERVER_URL = "/ueditor/jsp/controller";
    @Autowired
    private UeditorProperties properties;

    @Bean
    public ServletRegistrationBean<UeditorController> ueditorController() {
        UeditorController uc = new UeditorController();
        uc.setProperties(this.properties);
        ServletRegistrationBean srb = new ServletRegistrationBean((Servlet)uc, new String[0]);
        String serverUrl = StringUtils.isEmpty((Object)this.properties.getServerUrl()) ? DEFAULT_SERVER_URL : this.properties.getServerUrl();
        log.info("Ueditor Server Url: [{}]", (Object)serverUrl);
        srb.addUrlMappings(new String[]{serverUrl});
        return srb;
    }
}

