/*
 * Decompiled with CFR 0.152.
 */
package com.jason.ueditor.servlet;

import com.baidu.ueditor.ActionEnter;
import com.jason.ueditor.UeditorProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class UeditorController
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(UeditorController.class);
    private static String DEFAULT_ROOT_PATH = "classpath:/static";
    private UeditorProperties up;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        resp.setContentType("text/html;charset=UTF-8");
        String rootPath = DEFAULT_ROOT_PATH;
        if (!StringUtils.isEmpty((Object)this.up.getRootPath())) {
            rootPath = this.up.getRootPath();
        }
        rootPath = this.paserPath(rootPath);
        log.info("Ueditor root-path:[{}]", (Object)rootPath);
        resp.getWriter().write(new ActionEnter(req, rootPath).exec());
    }

    private String paserPath(String path) throws FileNotFoundException {
        if (StringUtils.isEmpty((Object)path)) {
            return path;
        }
        if (StringUtils.startsWithIgnoreCase((String)path, (String)"classpath:")) {
            path = path.substring(10);
            return ResourceUtils.getFile((String)"classpath:") + path;
        }
        return path;
    }

    public UeditorProperties getUp() {
        return this.up;
    }

    public void setUp(UeditorProperties up) {
        this.up = up;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UeditorController)) {
            return false;
        }
        UeditorController other = (UeditorController)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UeditorProperties this$up = this.getUp();
        UeditorProperties other$up = other.getUp();
        return !(this$up == null ? other$up != null : !((Object)this$up).equals(other$up));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UeditorController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UeditorProperties $up = this.getUp();
        result = result * 59 + ($up == null ? 43 : ((Object)$up).hashCode());
        return result;
    }

    public String toString() {
        return "UeditorController(up=" + this.getUp() + ")";
    }

    public UeditorController(UeditorProperties up) {
        this.up = up;
    }

    public UeditorController() {
    }
}

