package com.jason.ueditor.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

import com.baidu.ueditor.ActionEnter;
import com.jason.ueditor.UeditorProperties;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Slf4j
public class UeditorController extends HttpServlet {
	/**
	 * 默认资源目录
	 */
	private static String DEFAULT_ROOT_PATH = "classpath:/static";
	private UeditorProperties up;

	@Override
	protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		req.setCharacterEncoding("UTF-8");
		resp.setContentType("text/html;charset=UTF-8");
		String rootPath = DEFAULT_ROOT_PATH;
		if (!StringUtils.isEmpty(up.getRootPath())) {
			rootPath = up.getRootPath();
		}
		rootPath = paserPath(rootPath);
		log.info("Ueditor root-path:[{}]", rootPath);
		resp.getWriter().write(new ActionEnter(req, rootPath).exec());
	}

	private String paserPath(String path) throws FileNotFoundException {
		if (StringUtils.isEmpty(path))
			return path;
		if (StringUtils.startsWithIgnoreCase(path, "classpath:")) {
			path = path.substring(10);
			return ResourceUtils.getFile("classpath:") + path;
		}
		return path;
	}
}
