package com.jason.ueditor;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import lombok.Data;

@Component
@ConfigurationProperties("ue")
@Data
public class UeditorProperties {
	/**
	 * 上传文件存放目录
	 */
	private String rootPath;
	/**
	 * 统一服务接口名称配置,config.json存放目录为服务接口的上级目录 例: rootPath: classpath:/static
	 * serverUrl: /ueditor/controller 则config.json存放目录为:
	 * classpath:/static/ueditor/config.json
	 */
	private String serverUrl;
}
