/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.ueditor.upload;

import cn.jasonone.ueditor.upload.Config;
import cn.jasonone.ueditor.upload.LocationFileStorage;
import cn.jasonone.ueditor.upload.UeditorUpload;
import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.upload.IStorageManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class StorageManager
implements IStorageManager,
Config {
    public static final int BUFFER_SIZE = 8192;
    private static UeditorUpload upload;

    public StorageManager() {
        upload = new LocationFileStorage();
    }

    public StorageManager(UeditorUpload upload) {
        StorageManager.upload = upload;
    }

    public State saveBinaryFile(byte[] data, String rootPath, String savePath) {
        File file = new File(rootPath + savePath);
        BaseState state = upload.validFile(savePath);
        if (!state.isSuccess()) {
            return state;
        }
        try {
            upload.save(data, rootPath, savePath);
        }
        catch (IOException ioe) {
            return new BaseState(false, 4);
        }
        state = new BaseState(true, file.getAbsolutePath());
        state.putInfo("url", PathFormat.format((String)savePath));
        state.putInfo("size", (long)data.length);
        state.putInfo("title", file.getName());
        return state;
    }

    public State saveFileByInputStream(InputStream is, String rootPath, String savePath, long maxSize) {
        State state = null;
        File tmpFile = StorageManager.getTmpFile();
        byte[] dataBuf = new byte[2048];
        BufferedInputStream bis = new BufferedInputStream(is, 8192);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile), 8192);
            int count = 0;
            while ((count = bis.read(dataBuf)) != -1) {
                bos.write(dataBuf, 0, count);
            }
            bos.flush();
            bos.close();
            if (tmpFile.length() > maxSize) {
                tmpFile.delete();
                return new BaseState(false, 1);
            }
            state = StorageManager.saveTmpFile(tmpFile, rootPath, savePath);
            state.putInfo("url", PathFormat.format((String)savePath));
            if (!state.isSuccess()) {
                tmpFile.delete();
            }
            return state;
        }
        catch (IOException iOException) {
            return new BaseState(false, 4);
        }
    }

    public State saveFileByInputStream(InputStream is, String rootPath, String savePath) {
        State state = null;
        File tmpFile = StorageManager.getTmpFile();
        try {
            BufferedInputStream bis = new BufferedInputStream(is, 8192);
            byte[] dataBuf = new byte[2048];
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile), 8192);
            int count = 0;
            while ((count = bis.read(dataBuf)) != -1) {
                bos.write(dataBuf, 0, count);
            }
            bos.flush();
            bos.close();
            state = StorageManager.saveTmpFile(tmpFile, rootPath, savePath);
            state.putInfo("url", PathFormat.format((String)savePath));
            if (!state.isSuccess()) {
                tmpFile.delete();
            }
            return state;
        }
        catch (IOException iOException) {
            return new BaseState(false, 4);
        }
    }

    private static File getTmpFile() {
        File tmpDir = FileUtils.getTempDirectory();
        String tmpFileName = (Math.random() * 10000.0 + "").replace(".", "");
        return new File(tmpDir, tmpFileName);
    }

    private static State saveTmpFile(File tmpFile, String rootPath, String path) {
        BaseState state = null;
        File targetFile = new File(path);
        state = upload.validFile(path);
        if (!state.isSuccess()) {
            return state;
        }
        try {
            upload.save(tmpFile, rootPath, path);
        }
        catch (IOException e) {
            return new BaseState(false, 4);
        }
        state = new BaseState(true);
        state.putInfo("size", targetFile.length());
        state.putInfo("title", targetFile.getName());
        return state;
    }

    @Override
    public void setConfig(Map<String, Object> conf) {
        upload.setConfig(conf);
    }

    public static UeditorUpload getUpload() {
        return upload;
    }
}

