/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.ueditor.upload;

import cn.jasonone.ueditor.upload.UeditorUpload;
import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.MultiState;
import com.baidu.ueditor.define.State;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class LocationFileStorage
implements UeditorUpload {
    private Map<String, Object> config;
    private String rootPath;
    private String[] allowFiles;
    private String dir;
    private Integer count;

    @Override
    public BaseState validFile(String savePath) {
        File file = new File(this.rootPath, savePath);
        File parentPath = file.getParentFile();
        if (!parentPath.exists() && !parentPath.mkdirs()) {
            return new BaseState(false, 3);
        }
        if (!parentPath.canWrite()) {
            return new BaseState(false, 2);
        }
        return new BaseState(true);
    }

    @Override
    public void save(File file, String rootPath, String path) throws IOException {
        FileUtils.moveFile((File)file, (File)new File(rootPath, path));
    }

    @Override
    public void save(byte[] data, String rootPath, String savePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(rootPath, savePath)));
        bos.write(data);
        bos.flush();
        bos.close();
    }

    @Override
    public State listFile(int index) {
        File dir = new File(this.dir);
        MultiState state = null;
        if (!dir.exists()) {
            return new BaseState(false, 302);
        }
        if (!dir.isDirectory()) {
            return new BaseState(false, 301);
        }
        if (this.allowFiles == null) {
            this.allowFiles = this.getAllowFiles(this.config.get("allowFiles"));
        }
        Collection list = FileUtils.listFiles((File)dir, (String[])this.allowFiles, (boolean)true);
        if (index < 0 || index > list.size()) {
            state = new MultiState(true);
        } else {
            Object[] fileList = Arrays.copyOfRange(list.toArray(), index, index + this.count);
            state = this.getState(fileList);
        }
        state.putInfo("start", (long)index);
        state.putInfo("total", (long)list.size());
        return state;
    }

    @Override
    public MultiState getState(Object[] files) {
        MultiState state = new MultiState(true);
        BaseState fileState = null;
        File file = null;
        for (Object obj : files) {
            if (obj == null) break;
            file = (File)obj;
            fileState = new BaseState(true);
            fileState.putInfo("url", this.getPath(PathFormat.format((String)file.getAbsolutePath())));
            state.addState((State)fileState);
        }
        return state;
    }

    @Override
    public String getPath(String filePath) {
        return filePath.replace(this.rootPath, "");
    }

    @Override
    public void setConfig(Map<String, Object> conf) {
        this.config = conf;
        this.rootPath = (String)conf.get("rootPath");
        this.dir = this.rootPath + (String)conf.get("dir");
        this.count = (Integer)conf.get("count");
    }
}

