package cn.jasonone.ueditor.upload;

import java.io.File;
import java.io.IOException;
import java.util.Map;

import com.baidu.ueditor.define.BaseState;

public interface UeditorUpload extends FileManager,Config{
	
	
	/**
	 * 检测用于对于path是否拥有写权限
	 * 
	 * @param savePath 保存路径
	 * @return	处理结果
	 */
	public BaseState validFile(String savePath);

	/**
	 * 持久化文件信息
	 * 
	 * @param file     临时文件
	 * @param rootPath 文件保存根目录
	 * @param path     文件保存路径(相对于根目录)
	 * @throws IOException 文件处理出错
	 */
	public void save(File file, String rootPath, String path) throws IOException;

	/**
	 * 持久化文件信息
	 * 
	 * @param data     文件数据
	 * @param rootPath 文件保存根目录
	 * @param savePath 文件保存目录(相对于根目录)
	 * @throws IOException 文件处理出错
	 */
	public void save(byte[] data, String rootPath, String savePath) throws IOException;
}
