/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.jfx.util;

import cn.jasonone.jfx.controls.Controller;
import cn.jasonone.jfx.mananger.ControllerManager;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class NodeUtil {
    @Resource
    private ControllerManager controllerManager;

    public Set<Node> getChildNodes(Node node, Predicate<? super Node> filter) {
        Set nodes = node.lookupAll("*").stream().filter(filter).collect(Collectors.toSet());
        HashSet childNodes = new HashSet(nodes);
        for (Node n : nodes) {
            if (n == node) continue;
            childNodes.addAll(this.getChildNodes(n, filter));
        }
        return childNodes.stream().filter(filter).collect(Collectors.toSet());
    }

    public Set<Node> getChildNodes(Node node) {
        return this.getChildNodes(node, n -> true);
    }

    public <C> Set<C> getControllers(Node node) {
        return this.getControllers(node, c -> true);
    }

    public <C> Set<C> getControllers(Scene scene) {
        return this.controllerManager.getControllers(scene);
    }

    public <C> Set<C> getControllers(Node node, Predicate<Object> filter) {
        Set<Node> childNodes = this.getChildNodes(node, n -> n instanceof Parent || n instanceof Controller);
        return childNodes.stream().map(n -> this.controllerManager.getController((Parent)n)).filter(n -> n != null).filter(filter).collect(Collectors.toSet());
    }
}

