package cn.jasonone.jfx.mananger;

import javafx.scene.Scene;
import javafx.stage.Stage;

/**
 * 舞台管理器
 *
 * @author xujie
 * @version 1.0
 * @date 2021/12/22 8:45
 */
public interface StageManager {
    /**
     * 获取主舞台对象
     *
     * @return
     */
    Stage getPrimaryStage();

    /**
     * 将场景与舞台绑定
     *
     * @param stage 舞台对象
     * @param scene 场景对象
     */
    void bindScene(Stage stage, Scene scene);

    /**
     * 将场景与主舞台绑定
     *
     * @param scene 场景对象
     */
    default void bindScene(Scene scene) {
        this.bindScene(getPrimaryStage(), scene);
    }

    /**
     * 通过制定控制器创建舞台
     * @param controllerType
     * @param title
     * @return
     */
    Stage createStage(Class controllerType, String title) throws Exception;
}
