package cn.jasonone.jfx.mananger;

import cn.jasonone.jfx.mananger.aware.StageManagerAware;
import javafx.scene.Parent;
import javafx.scene.Scene;

/**
 * 场景管理器
 *
 * @author xujie
 * @version 1.0
 * @date 2021/12/22 9:55
 */
public interface SceneManager extends StageManagerAware {
    /**
     * 获取主场景对象
     *
     * @return
     */
    Scene getPrimaryScene();
    /**
     * 创建场景
     * @param controllerType 控制器
     * @return
     */
    Scene createScene(Class controllerType) throws Exception;

    /**
     * 绑定根节点到场景
     *
     * @param scene 场景对象
     * @param root  根节点对象
     */
    void bindRootParent(Scene scene, Parent root);

    /**
     * 绑定根节点到主场景中
     *
     * @param root 根节点
     */
    default void bindRootParent(Parent root) {
        this.bindRootParent(getPrimaryScene(), root);
    }

    /**
     * 绑定指定控制器的节点到场景
     *
     * @param scene          场景对象
     * @param controllerType 控制器类型
     */
    void bindRootParent(Scene scene, Class controllerType);

    /**
     * 绑定指定控制器的节点到主场景
     *
     * @param controllerType 控制器类型
     */
    default void bindRootParent(Class controllerType) {
        this.bindRootParent(getPrimaryScene(), controllerType);
    }

    /**
     * 获得场景根节点
     *
     * @param scene 场景对象
     * @param <P>
     * @return
     */
    <P extends Parent> P getRootParent(Scene scene);
}
