package cn.jasonone.jfx.mananger;

import javafx.scene.Parent;
import javafx.scene.Scene;

import java.util.Set;

/**
 * @author xujie
 * @version 1.0
 * @date 2021/12/22 10:29
 */
public interface ControllerManager {
    /**
     * 通过节点获取处理器对象
     *
     * @param parent
     * @param <C>
     * @return
     */
    <C> C getController(Parent parent);

    /**
     * 获取场景中所有的控制器
     *
     * @param scene
     * @param <C>
     * @return
     */
    <C> Set<C> getControllers(Scene scene);

    /**
     * 将控件与控制器绑定
     *
     * @param pane
     * @param controller
     */
    void bindController(Parent pane, Object controller);

    /**
     * 检查控制器是否存在
     *
     * @param pane
     * @return
     */
    boolean hasController(Parent pane);
}
