package cn.jasonone.jfx.factory;

/**
 * Bean工厂,用于创建实体对象
 *
 * @author xujie
 * @version 1.0
 * @date 2021/12/23 14:04
 */
public interface BeanFactory {
    /**
     * 根据Bean类型获取Bean对象
     *
     * @param clazz Bean的类型
     * @param <T>
     * @return
     */
    default <T> T getBean(Class<T> clazz) {
        try {
            return clazz.newInstance();
        } catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}
