package cn.jasonone.jfx.controls;

import cn.hutool.core.util.ClassUtil;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Parent;
import javafx.scene.layout.*;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import lombok.Data;

/**
 * @author xujie
 * @version 1.0
 * @date 2022/1/6 16:07
 */
@Data
public class Controller extends AnchorPane {
    private StringProperty controller = new SimpleStringProperty();

    private boolean borderEnable;

    private StringProperty borderColor = new SimpleStringProperty();

    private Border _border;

    public Controller() {

    }

    /**
     * 渲染组件
     */
    public final void render(Parent parent) {
        this.getChildren().clear();
        this.getChildren().add(parent);
        AnchorPane.setLeftAnchor(parent, 0D);
        AnchorPane.setRightAnchor(parent, 0D);
        AnchorPane.setTopAnchor(parent, 0D);
        AnchorPane.setBottomAnchor(parent, 0D);
    }

    public boolean isBorderEnable() {
        return borderEnable;
    }


    public void setBorderEnable(boolean borderEnable) {
        this.borderEnable = borderEnable;
        if (this.borderEnable) {
            if (borderColor.isEmpty().get()) {
                setBorderColor("#00f");
            }
            _border = new Border(new BorderStroke(Paint.valueOf(borderColor.get()), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT));
            this.setBorder(_border);
        }
    }

    public String getBorderColor() {
        return borderColor.get();
    }

    public StringProperty borderColorProperty() {
        return borderColor;
    }

    public void setBorderColor(String borderColor) {
        this.borderColor.set(borderColor);
        if (this.isBorderEnable()) {
            this.setBorderEnable(true);
        }
    }

    public final String getController() {
        return controller.get();
    }

    public final StringProperty controllerProperty() {
        return controller;
    }

    public final void setController(String controller) {
        this.controller.set(controller);
    }
}
