package cn.jasonone.jfx.annotations;

import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.*;

/**
 * 属性绑定
 *
 * @author xujie
 * @version 1.0
 * @date 2021/12/22 16:22
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@Repeatable(BindPropertys.class)
public @interface BindProperty {
    /**
     * 控件ID
     *
     * @return
     */
    String fxmlId() default "";

    /**
     * 控件属性名称
     *
     * @return
     */
    @AliasFor("value")
    String attributeName() default "";

    /**
     * 控件属性名称
     * @return
     */
    @AliasFor("attributeName")
    String value() default "";
}
