package cn.jasonone.jfx.util;

import cn.jasonone.jfx.mananger.ControllerManager;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/**
 * @author xujie
 * @version 1.0
 * @date 2021/12/22 10:02
 */
@Component
public class NodeUtil {
    @Resource
    private ControllerManager controllerManager;

    /**
     * 获取节点的子节点信息
     *
     * @param node   节点对象
     * @param filter 过滤器
     * @return
     */
    public Set<Node> getChildNodes(Node node, Predicate<? super Node> filter) {
        Set<Node> nodes = node.lookupAll("*");
        return nodes.stream().filter(filter).collect(Collectors.toSet());
    }

    /**
     * 获取节点的子节点信息
     *
     * @param node 节点对象
     * @return
     */
    public Set<Node> getChildNodes(Node node) {
        Set<Node> nodes = node.lookupAll("*");
        return getChildNodes(node, n -> true);
    }

    /**
     * 获取节点中的所有控制器
     *
     * @param node
     * @return
     */
    public <C> Set<C> getControllers(Node node) {
        return (Set<C>) getControllers(node, c -> true);
    }

    /**
     * 获取节点中的所有控制器
     *
     * @param node
     * @return
     */
    public <C> Set<C> getControllers(Node node, Predicate<Object> filter) {
        Set<Node> childNodes = getChildNodes(node);
        return (Set<C>) childNodes.stream()
                // 过滤非布局控件
                .filter(n -> n instanceof Parent)
                // 获取布局控件的处理器
                .map(n -> controllerManager.getController((Parent) n))
                // 过滤空值
                .filter(n -> n != null)
                .filter(filter).collect(Collectors.toSet());
    }
}
