package cn.jasonone.jfx.factory;

import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

import java.util.List;

/**
 * 样式拦截器
 *
 * @author xujie
 * @version 1.0
 * @date 2021/12/21 12:07
 */
public interface StyleSheetInterceptor {
    /**
     * 是否启用样式拦截器
     *
     * @param stage    当前要应用样式的舞台
     * @param scene    当前要应用样式的场景
     * @param rootPane 当前要应用样式的节点
     * @return
     */
    default boolean isEnabled(Stage stage, Scene scene, Parent rootPane) {
        return true;
    }

    /**
     * 处理样式列表
     *
     * @param styleSheetList
     */
    void handler(List<String> styleSheetList);
}
